/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxes;

import java.text.ParseException;
import org.apache.directory.shared.ldap.aci.ACIItemChecker;
import org.apache.directory.shared.ldap.schema.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class ACIItemSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.1";
    private ACIItemChecker checker = new ACIItemChecker();

    public ACIItemSyntaxChecker() {
        super(SC_OID);
    }

    protected ACIItemSyntaxChecker(String oid) {
        super(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        try {
            ACIItemChecker aCIItemChecker = this.checker;
            synchronized (aCIItemChecker) {
                this.checker.parse(strValue);
            }
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }
}

