/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.CertGenerationDecoder;
import org.apache.directory.shared.ldap.codec.extended.operations.CertGenerationObject;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.extended.CertGenerationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerationRequest
extends ExtendedRequestImpl {
    private CertGenerationObject certGenObj;
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationRequest.class);
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.6";

    public CertGenerationRequest(int messageId, String targerDN, String issuerDN, String subjectDN, String keyAlgorithm) {
        super(messageId);
        this.setOid(EXTENSION_OID);
        this.certGenObj = new CertGenerationObject();
        this.certGenObj.setTargetDN(targerDN);
        this.certGenObj.setIssuerDN(issuerDN);
        this.certGenObj.setSubjectDN(subjectDN);
        this.certGenObj.setKeyAlgorithm(keyAlgorithm);
    }

    private void encodePayload() throws EncoderException {
        this.payload = this.certGenObj.encode(null).array();
    }

    public void setPayload(byte[] payload) {
        CertGenerationDecoder decoder = new CertGenerationDecoder();
        try {
            this.certGenObj = (CertGenerationObject)decoder.decode(payload);
            if (payload != null) {
                this.payload = new byte[payload.length];
                System.arraycopy(payload, 0, this.payload, 0, payload.length);
            } else {
                this.payload = null;
            }
        }
        catch (DecoderException e) {
            LOG.error("failed to decode payload", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return (ExtendedResponse)((Object)this.getResultResponse());
    }

    public byte[] getEncodedValue() {
        return this.getPayload();
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            try {
                this.encodePayload();
            }
            catch (EncoderException e) {
                LOG.error("Failed to encode payload CertGenerateRequest", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.payload == null) {
            return null;
        }
        byte[] copy = new byte[this.payload.length];
        System.arraycopy(this.payload, 0, copy, 0, this.payload.length);
        return copy;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new CertGenerationResponse(this.getMessageId());
        }
        return this.response;
    }

    public String getTargetDN() {
        return this.certGenObj.getTargetDN();
    }

    public void setTargetDN(String targetDN) {
        this.certGenObj.setTargetDN(targetDN);
    }

    public String getIssuerDN() {
        return this.certGenObj.getIssuerDN();
    }

    public void setIssuerDN(String issuerDN) {
        this.certGenObj.setIssuerDN(issuerDN);
    }

    public String getSubjectDN() {
        return this.certGenObj.getSubjectDN();
    }

    public void setSubjectDN(String subjectDN) {
        this.certGenObj.setSubjectDN(subjectDN);
    }

    public String getKeyAlgorithm() {
        return this.certGenObj.getKeyAlgorithm();
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.certGenObj.setKeyAlgorithm(keyAlgorithm);
    }
}

