/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.control.replication;

import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue.SyncStateValueControlCodec;
import org.apache.directory.shared.ldap.message.control.AbstractMutableControlImpl;
import org.apache.directory.shared.ldap.message.control.replication.SyncStateTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStateValueControl
extends AbstractMutableControlImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncStateValueControl.class);
    public static final String CONTROL_OID = "1.3.6.1.4.1.4203.1.9.1.2";
    private SyncStateTypeEnum syncStateType;
    private byte[] entryUUID;
    private byte[] cookie;

    public SyncStateTypeEnum getSyncStateType() {
        return this.syncStateType;
    }

    public void setSyncStateType(SyncStateTypeEnum syncStateType) {
        this.syncStateType = syncStateType;
    }

    public byte[] getEntryUUID() {
        return this.entryUUID;
    }

    public void setEntryUUID(byte[] entryUUID) {
        this.entryUUID = entryUUID;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public String getID() {
        return CONTROL_OID;
    }

    public byte[] getEncodedValue() {
        SyncStateValueControlCodec syncStateValueCtlCodec = new SyncStateValueControlCodec();
        syncStateValueCtlCodec.setSyncStateType(this.syncStateType);
        syncStateValueCtlCodec.setEntryUUID(this.entryUUID);
        syncStateValueCtlCodec.setCookie(this.cookie);
        try {
            return syncStateValueCtlCodec.encode(null).array();
        }
        catch (EncoderException e) {
            LOG.error("Failed to encode syncStateValue control", (Throwable)e);
            throw new IllegalStateException("Failed to encode control with encoder.", e);
        }
    }
}

