/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedure
extends AbstractAsn1Object {
    private String language;
    private byte[] procedure;
    private List<StoredProcedureParameter> parameters = new ArrayList<StoredProcedureParameter>();
    private StoredProcedureParameter currentParameter;
    private int storedProcedureLength;
    private int parametersLength;
    private List<Integer> parameterLength;
    private List<Integer> paramTypeLength;
    private List<Integer> paramValueLength;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public byte[] getProcedure() {
        if (this.procedure == null) {
            return null;
        }
        byte[] copy = new byte[this.procedure.length];
        System.arraycopy(this.procedure, 0, copy, 0, this.procedure.length);
        return copy;
    }

    public void setProcedure(byte[] procedure) {
        if (procedure != null) {
            this.procedure = new byte[procedure.length];
            System.arraycopy(procedure, 0, this.procedure, 0, procedure.length);
        } else {
            this.procedure = null;
        }
    }

    public List<StoredProcedureParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(StoredProcedureParameter parameter) {
        this.parameters.add(parameter);
    }

    public StoredProcedureParameter getCurrentParameter() {
        return this.currentParameter;
    }

    public void setCurrentParameter(StoredProcedureParameter currentParameter) {
        this.currentParameter = currentParameter;
    }

    public int computeLength() {
        byte[] languageBytes = StringTools.getBytesUtf8(this.language);
        int languageLength = 1 + TLV.getNbBytes((int)languageBytes.length) + languageBytes.length;
        int procedureLength = 1 + TLV.getNbBytes((int)this.procedure.length) + this.procedure.length;
        if (this.parameters != null) {
            this.parameterLength = new LinkedList<Integer>();
            this.paramTypeLength = new LinkedList<Integer>();
            this.paramValueLength = new LinkedList<Integer>();
            for (StoredProcedureParameter spParam : this.parameters) {
                int localParameterLength = 0;
                int localParamTypeLength = 0;
                int localParamValueLength = 0;
                localParamTypeLength = 1 + TLV.getNbBytes((int)spParam.type.length) + spParam.type.length;
                localParamValueLength = 1 + TLV.getNbBytes((int)spParam.value.length) + spParam.value.length;
                localParameterLength = localParamTypeLength + localParamValueLength;
                this.parametersLength += 1 + TLV.getNbBytes((int)localParameterLength) + localParameterLength;
                this.parameterLength.add(localParameterLength);
                this.paramTypeLength.add(localParamTypeLength);
                this.paramValueLength.add(localParamValueLength);
            }
        }
        int localParametersLength = 1 + TLV.getNbBytes((int)this.parametersLength) + this.parametersLength;
        this.storedProcedureLength = languageLength + procedureLength + localParametersLength;
        return 1 + TLV.getNbBytes((int)this.storedProcedureLength) + this.storedProcedureLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        try {
            bb.put((byte)48);
            bb.put(TLV.getBytes((int)this.storedProcedureLength));
            Value.encode((ByteBuffer)bb, (String)this.language);
            Value.encode((ByteBuffer)bb, (byte[])this.procedure);
            bb.put((byte)48);
            bb.put(TLV.getBytes((int)this.parametersLength));
            if (this.parameters != null && this.parameters.size() != 0) {
                int parameterNumber = 0;
                for (StoredProcedureParameter spParam : this.parameters) {
                    bb.put((byte)48);
                    int localParameterLength = this.parameterLength.get(parameterNumber);
                    bb.put(TLV.getBytes((int)localParameterLength));
                    Value.encode((ByteBuffer)bb, (byte[])spParam.type);
                    Value.encode((ByteBuffer)bb, (byte[])spParam.value);
                    ++parameterNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    StoredProcedure\n");
        sb.append("        Language : '").append(this.language).append("'\n");
        sb.append("        Procedure\n").append(StringTools.utf8ToString(this.procedure)).append("'\n");
        if (this.parameters == null || this.parameters.size() == 0) {
            sb.append("        No parameters\n");
        } else {
            sb.append("        Parameters\n");
            int i = 1;
            for (StoredProcedureParameter spParam : this.parameters) {
                sb.append("            type[").append(i).append("] : '").append(StringTools.utf8ToString(spParam.type)).append("'\n");
                sb.append("            value[").append(i).append("] : '").append(StringTools.dumpBytes(spParam.value)).append("'\n");
            }
        }
        return sb.toString();
    }

    public static class StoredProcedureParameter {
        byte[] type;
        byte[] value;

        public byte[] getType() {
            if (this.type == null) {
                return null;
            }
            byte[] copy = new byte[this.type.length];
            System.arraycopy(this.type, 0, copy, 0, this.type.length);
            return copy;
        }

        public void setType(byte[] type) {
            if (type != null) {
                this.type = new byte[type.length];
                System.arraycopy(type, 0, this.type, 0, type.length);
            } else {
                this.type = null;
            }
        }

        public byte[] getValue() {
            if (this.value == null) {
                return null;
            }
            byte[] copy = new byte[this.value.length];
            System.arraycopy(this.value, 0, copy, 0, this.value.length);
            return copy;
        }

        public void setValue(byte[] value) {
            if (value != null) {
                this.value = new byte[value.length];
                System.arraycopy(value, 0, this.value, 0, value.length);
            } else {
                this.value = null;
            }
        }
    }
}

