/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import org.apache.directory.shared.asn1.ber.AbstractContainer;
import org.apache.directory.shared.ldap.codec.Control;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageGrammar;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;

public class LdapMessageContainer
extends AbstractContainer {
    private LdapMessage ldapMessage;
    private final BinaryAttributeDetector binaryAttributeDetector;
    private int messageId;
    private Control currentControl;

    public LdapMessageContainer() {
        this(new BinaryAttributeDetector(){

            public boolean isBinary(String attributeId) {
                return false;
            }
        });
    }

    public LdapMessageContainer(BinaryAttributeDetector binaryAttributeDetector) {
        this.stateStack = new int[10];
        this.grammar = LdapMessageGrammar.getInstance();
        this.states = LdapStatesEnum.getInstance();
        this.binaryAttributeDetector = binaryAttributeDetector;
    }

    public LdapMessage getLdapMessage() {
        return this.ldapMessage;
    }

    public void setLdapMessage(LdapMessage ldapMessage) {
        this.ldapMessage = ldapMessage;
    }

    public void clean() {
        super.clean();
        this.ldapMessage = null;
        this.messageId = 0;
        this.currentControl = null;
        this.decodeBytes = 0;
    }

    public boolean isBinary(String id) {
        return this.binaryAttributeDetector.isBinary(id);
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public Control getCurrentControl() {
        return this.currentControl;
    }

    public void setCurrentControl(Control currentControl) {
        this.currentControl = currentControl;
    }
}

