/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifAttributesReader;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifUtils {
    private static boolean[] LDIF_SAFE_STARTING_CHAR_ALPHABET;
    private static boolean[] LDIF_SAFE_OTHER_CHARS_ALPHABET;
    private static final int DEFAULT_LINE_LENGTH = 80;

    public static boolean isLDIFSafe(String str) {
        if (str == null) {
            return true;
        }
        char currentChar = str.charAt(0);
        if (currentChar > '\u007f' || !LDIF_SAFE_STARTING_CHAR_ALPHABET[currentChar]) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            currentChar = str.charAt(i);
            if (currentChar <= '\u007f' && LDIF_SAFE_OTHER_CHARS_ALPHABET[currentChar]) continue;
            return false;
        }
        return currentChar != ' ';
    }

    public static String convertToLdif(Attributes attrs) throws NamingException {
        return LdifUtils.convertToLdif(AttributeUtils.toClientEntry(attrs, null), 80);
    }

    public static String convertToLdif(Attributes attrs, int length) throws NamingException {
        return LdifUtils.convertToLdif(AttributeUtils.toClientEntry(attrs, null), length);
    }

    public static String convertToLdif(Attributes attrs, LdapDN dn, int length) throws NamingException {
        return LdifUtils.convertToLdif(AttributeUtils.toClientEntry(attrs, dn), length);
    }

    public static String convertToLdif(Attributes attrs, LdapDN dn) throws NamingException {
        return LdifUtils.convertToLdif(AttributeUtils.toClientEntry(attrs, dn), 80);
    }

    public static String convertToLdif(Entry attrs) throws NamingException {
        return LdifUtils.convertToLdif(attrs, 80);
    }

    public static Attributes convertAttributesFromLdif(String ldif) throws NamingException {
        LdifAttributesReader reader = new LdifAttributesReader();
        return reader.parseAttributes(ldif);
    }

    public static String convertToLdif(Entry entry, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        for (EntryAttribute attribute : entry) {
            sb.append(LdifUtils.convertToLdif(attribute, length));
        }
        return sb.toString();
    }

    public static String convertToLdif(LdifEntry entry) throws NamingException {
        return LdifUtils.convertToLdif(entry, 80);
    }

    public static String convertToLdif(LdifEntry entry, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        if (LdifUtils.isLDIFSafe(entry.getDn().getUpName())) {
            sb.append(LdifUtils.stripLineToNChars("dn: " + entry.getDn(), length));
        } else {
            sb.append(LdifUtils.stripLineToNChars("dn:: " + LdifUtils.encodeBase64(entry.getDn().getUpName()), length));
        }
        sb.append('\n');
        sb.append(LdifUtils.stripLineToNChars("changeType: " + (Object)((Object)entry.getChangeType()), length));
        sb.append('\n');
        switch (entry.getChangeType()) {
            case Delete: {
                if (entry.getEntry() == null) break;
                throw new NamingException("Invalid Entry : a deleted entry should not contain attributes");
            }
            case Add: {
                if (entry.getEntry() == null) {
                    throw new NamingException("Invalid Entry : a added or modified entry should contain attributes");
                }
                for (EntryAttribute attribute : entry.getEntry()) {
                    sb.append(LdifUtils.convertToLdif(attribute, length));
                }
                break;
            }
            case ModDn: 
            case ModRdn: {
                if (entry.getEntry() != null) {
                    throw new NamingException("Invalid Entry : a modifyDN operation entry should not contain attributes");
                }
                sb.append("deleteoldrdn: ");
                if (entry.isDeleteOldRdn()) {
                    sb.append("1");
                } else {
                    sb.append("0");
                }
                sb.append('\n');
                if (!StringTools.isEmpty(entry.getNewSuperior())) {
                    DefaultClientAttribute newSuperior = new DefaultClientAttribute("newsuperior", entry.getNewSuperior());
                    sb.append(LdifUtils.convertToLdif(newSuperior, length));
                }
                DefaultClientAttribute newRdn = new DefaultClientAttribute("newrdn", entry.getNewRdn());
                sb.append(LdifUtils.convertToLdif(newRdn, length));
                break;
            }
            case Modify: {
                for (Modification modification : entry.getModificationItems()) {
                    switch (modification.getOperation()) {
                        case ADD_ATTRIBUTE: {
                            sb.append("add: ");
                            break;
                        }
                        case REMOVE_ATTRIBUTE: {
                            sb.append("delete: ");
                            break;
                        }
                        case REPLACE_ATTRIBUTE: {
                            sb.append("replace: ");
                            break;
                        }
                    }
                    sb.append(modification.getAttribute().getId());
                    sb.append('\n');
                    sb.append(LdifUtils.convertToLdif(modification.getAttribute()));
                    sb.append("-\n");
                }
                break;
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private static String encodeBase64(String str) {
        char[] encoded = null;
        try {
            encoded = Base64.encode(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            encoded = Base64.encode(str.getBytes());
        }
        return new String(encoded);
    }

    public static String convertToLdif(EntryAttribute attr) throws NamingException {
        return LdifUtils.convertToLdif(attr, 80);
    }

    public static String convertToLdif(EntryAttribute attr, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        for (Value value : attr) {
            StringBuilder lineBuffer = new StringBuilder();
            lineBuffer.append(attr.getId());
            if (value == null) {
                lineBuffer.append(':');
            } else if (value instanceof ClientBinaryValue) {
                char[] encoded = Base64.encode((byte[])value.get());
                lineBuffer.append(":: " + new String(encoded));
            } else if (value instanceof ClientStringValue) {
                String str = (String)value.get();
                if (!LdifUtils.isLDIFSafe(str)) {
                    lineBuffer.append(":: " + LdifUtils.encodeBase64(str));
                } else {
                    lineBuffer.append(":");
                    if (str != null) {
                        lineBuffer.append(" ").append(str);
                    }
                }
            }
            lineBuffer.append("\n");
            sb.append(LdifUtils.stripLineToNChars(lineBuffer.toString(), length));
        }
        return sb.toString();
    }

    public static String stripLineToNChars(String str, int nbChars) {
        int strLength = str.length();
        if (strLength <= nbChars) {
            return str;
        }
        if (nbChars < 2) {
            throw new IllegalArgumentException("The length of each line must be at least 2 chars long");
        }
        int charsPerLine = nbChars - 1;
        int remaining = (strLength - nbChars) % charsPerLine;
        int nbLines = 1 + (strLength - nbChars) / charsPerLine + (remaining == 0 ? 0 : 1);
        int nbCharsTotal = strLength + nbLines + nbLines - 2;
        char[] buffer = new char[nbCharsTotal];
        char[] orig = str.toCharArray();
        int posSrc = 0;
        int posDst = 0;
        System.arraycopy(orig, posSrc, buffer, posDst, nbChars);
        posSrc += nbChars;
        posDst += nbChars;
        for (int i = 0; i < nbLines - 2; ++i) {
            buffer[posDst++] = 10;
            buffer[posDst++] = 32;
            System.arraycopy(orig, posSrc, buffer, posDst, charsPerLine);
            posSrc += charsPerLine;
            posDst += charsPerLine;
        }
        buffer[posDst++] = 10;
        buffer[posDst++] = 32;
        System.arraycopy(orig, posSrc, buffer, posDst, remaining == 0 ? charsPerLine : remaining);
        return new String(buffer);
    }

    public static LdifEntry reverseAdd(LdapDN dn) {
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Delete);
        entry.setDn(dn);
        return entry;
    }

    public static LdifEntry reverseDel(LdapDN dn, Entry deletedEntry) throws NamingException {
        LdifEntry entry = new LdifEntry();
        entry.setDn(dn);
        entry.setChangeType(ChangeType.Add);
        for (EntryAttribute attribute : deletedEntry) {
            entry.addAttribute(attribute);
        }
        return entry;
    }

    public static LdifEntry reverseModifyDn(LdapDN newSuperiorDn, LdapDN modifiedDn) throws NamingException {
        LdifEntry entry = new LdifEntry();
        LdapDN currentParent = null;
        LdapDN newDn = null;
        if (newSuperiorDn == null) {
            throw new NullPointerException("newSuperiorDn must not be null");
        }
        if (modifiedDn == null) {
            throw new NullPointerException("modifiedDn must not be null");
        }
        if (modifiedDn.size() == 0) {
            throw new IllegalArgumentException("Don't think about moving the rootDSE.");
        }
        currentParent = (LdapDN)modifiedDn.clone();
        currentParent.remove(currentParent.size() - 1);
        newDn = (LdapDN)newSuperiorDn.clone();
        newDn.add(modifiedDn.getRdn());
        entry.setChangeType(ChangeType.ModDn);
        entry.setDn(newDn);
        entry.setNewSuperior(currentParent.getUpName());
        entry.setDeleteOldRdn(false);
        return entry;
    }

    public static List<LdifEntry> reverseRename(Attributes t0, LdapDN t0_dn, Rdn t1_rdn) throws NamingException {
        LdifEntry entry = new LdifEntry();
        LdapDN parent = null;
        LdapDN newDn = null;
        if (t1_rdn == null) {
            throw new NullPointerException("newRdn must not be null");
        }
        if (t0_dn == null) {
            throw new NullPointerException("modifiedDn must not be null");
        }
        if (t0_dn.size() == 0) {
            throw new IllegalArgumentException("Don't think about renaming the rootDSE.");
        }
        parent = (LdapDN)t0_dn.clone();
        parent.remove(parent.size() - 1);
        newDn = (LdapDN)parent.clone();
        newDn.add(t1_rdn);
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>(1);
        entry.setChangeType(ChangeType.ModRdn);
        entry.setDeleteOldRdn(LdifUtils.reverseDoDeleteOldRdn(t0, t1_rdn));
        entry.setDn(newDn);
        entry.setNewRdn(t0_dn.getRdn().getUpName());
        entries.add(entry);
        return entries;
    }

    public static List<LdifEntry> reverseModifyRdn(Attributes t0, LdapDN t1_parentDn, LdapDN t0_dn, Rdn t1_rdn) throws NamingException {
        if (t0_dn == null) {
            throw new NullPointerException("t0_dn must not be null");
        }
        if (t0_dn.size() == 0) {
            throw new IllegalArgumentException("Don't think about a move op on the rootDSE.");
        }
        if (t1_parentDn == null) {
            return LdifUtils.reverseRename(t0, t0_dn, t1_rdn);
        }
        if (t1_rdn == null) {
            ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>(1);
            LdifEntry entry = LdifUtils.reverseModifyDn(t1_parentDn, t0_dn);
            entries.add(entry);
            return entries;
        }
        LdifEntry reverse = new LdifEntry();
        LdapDN reverseNewSuperiorDn = (LdapDN)t0_dn.clone();
        reverseNewSuperiorDn.remove(reverseNewSuperiorDn.size() - 1);
        Rdn reverseNewRdn = t0_dn.getRdn();
        LdapDN reverseDn = (LdapDN)t1_parentDn.clone();
        reverseDn.add(t1_rdn);
        reverse.setDn(reverseDn);
        reverse.setNewSuperior(reverseNewSuperiorDn.getUpName());
        reverse.setNewRdn(reverseNewRdn.getUpName());
        reverse.setChangeType(ChangeType.ModRdn);
        reverse.setDeleteOldRdn(LdifUtils.reverseDoDeleteOldRdn(t0, t1_rdn));
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>(1);
        entries.add(reverse);
        return entries;
    }

    private static boolean reverseDoDeleteOldRdn(Attributes t0_entry, Rdn t1_rdn) {
        Attribute t0_attr = t0_entry.get(t1_rdn.getUpType());
        return t0_attr == null || !t0_attr.contains(t1_rdn.getUpValue());
    }

    public static LdifEntry reverseModify(LdapDN dn, List<Modification> forwardModifications, Entry modifiedEntry) throws NamingException {
        Entry clonedEntry = modifiedEntry.clone();
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Modify);
        entry.setDn(dn);
        ArrayList<ClientModification> reverseModifications = new ArrayList<ClientModification>();
        block5: for (Modification modification : forwardModifications) {
            switch (modification.getOperation()) {
                case ADD_ATTRIBUTE: {
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = modifiedEntry.get(mod.getId());
                    if (mod.equals(previous)) continue block5;
                    ClientModification reverseModification = new ClientModification(ModificationOperation.REMOVE_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    ClientModification reverseModification;
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = modifiedEntry.get(mod.getId());
                    if (previous == null) continue block5;
                    if (mod.get() == null) {
                        reverseModification = new ClientModification(ModificationOperation.ADD_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    reverseModification = new ClientModification(ModificationOperation.ADD_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    ClientModification reverseModification;
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = modifiedEntry.get(mod.getId());
                    if (mod.get() == null && previous == null) {
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)new DefaultClientAttribute(mod.getId()));
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (mod.get() == null) {
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (previous == null) {
                        DefaultClientAttribute emptyAttribute = new DefaultClientAttribute(mod.getId());
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)emptyAttribute);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
            }
            AttributeUtils.applyModification(clonedEntry, modification);
        }
        if (reverseModifications.size() == 0) {
            throw new IllegalArgumentException("Could not deduce reverse modifications from provided modifications: " + forwardModifications);
        }
        for (Modification modification : reverseModifications) {
            entry.addModificationItem(modification);
        }
        return entry;
    }

    static {
        int i;
        LDIF_SAFE_STARTING_CHAR_ALPHABET = new boolean[128];
        LDIF_SAFE_OTHER_CHARS_ALPHABET = new boolean[128];
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[13] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[32] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[58] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[60] = false;
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[13] = false;
    }
}

