/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class OtherMailboxSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.39";

    public OtherMailboxSyntaxChecker() {
        super(SC_OID);
    }

    protected OtherMailboxSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String mailbox;
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar == -1) {
            return false;
        }
        String mailboxType = strValue.substring(0, dollar);
        String string = mailbox = dollar < strValue.length() - 1 ? strValue.substring(dollar + 1) : "";
        if (mailbox.indexOf(36) != -1) {
            return false;
        }
        if (!StringTools.isPrintableString(mailboxType)) {
            return false;
        }
        return StringTools.isIA5String(mailbox);
    }
}

