/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTypeAndValue
implements Cloneable,
Comparable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = LoggerFactory.getLogger(AttributeTypeAndValue.class);
    private String normType;
    private String upType;
    private Object normValue;
    private Object upValue;
    private String upName;
    private int start;
    private int length;
    private static final boolean CASE_SENSITIVE = true;
    private static final boolean CASE_INSENSITIVE = false;
    private static final boolean[] DN_ESCAPED_CHARS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public AttributeTypeAndValue() {
        this.normType = null;
        this.upType = null;
        this.normValue = null;
        this.upValue = null;
        this.upName = "";
        this.start = -1;
        this.length = 0;
    }

    public AttributeTypeAndValue(String upType, String normType, Object upValue, Object normValue) throws InvalidNameException {
        String upTypeTrimmed = StringTools.trim(upType);
        String normTypeTrimmed = StringTools.trim(normType);
        if (StringTools.isEmpty(upTypeTrimmed)) {
            if (StringTools.isEmpty(normTypeTrimmed)) {
                String message = "The type cannot be empty or null";
                LOG.error(message);
                throw new InvalidNameException(message);
            }
            this.normType = StringTools.lowerCaseAscii(normTypeTrimmed);
            this.upType = normType;
        } else if (StringTools.isEmpty(normTypeTrimmed)) {
            this.normType = StringTools.lowerCaseAscii(upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = StringTools.lowerCaseAscii(normTypeTrimmed);
            this.upType = upType;
        }
        if (normValue == null || upValue == null) {
            this.normValue = normValue instanceof String ? (StringTools.isEmpty((String)normValue) ? "" : normValue) : normValue;
            this.upValue = upValue instanceof String ? (StringTools.isEmpty((String)upValue) ? "" : upValue) : upValue;
        } else {
            this.upValue = upValue;
            this.normValue = normValue instanceof String ? (StringTools.isEmpty((String)normValue) ? "" : normValue) : normValue;
        }
        this.upName = this.upType + '=' + (this.upValue == null ? "" : this.upValue);
        this.start = 0;
        this.length = this.upName.length();
    }

    AttributeTypeAndValue(String upType, String normType, Object upValue, Object normValue, int start, int length, String upName) {
        this.upType = upType;
        this.normType = normType;
        this.upValue = upValue;
        this.normValue = normValue;
        this.start = start;
        this.length = length;
        this.upName = upName;
    }

    public String getNormType() {
        return this.normType;
    }

    public String getUpType() {
        return this.upType;
    }

    public void setType(String upType, String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            String message = "The type cannot be empty or null";
            LOG.error(message);
            throw new InvalidNameException(message);
        }
        if (StringTools.isEmpty(upType) || StringTools.isEmpty(upType.trim())) {
            String message = "The User Provided type cannot be empty or null";
            LOG.error(message);
            throw new InvalidNameException(message);
        }
        int equalPosition = this.upName.indexOf(61);
        if (equalPosition <= 1) {
            String message = "The User provided name does not contains an '='";
            LOG.error(message);
            throw new InvalidNameException(message);
        }
        this.normType = type.trim().toLowerCase();
        this.upType = upType;
        this.upName = upType + this.upName.substring(equalPosition);
        this.start = -1;
        this.length = this.upName.length();
    }

    public void setTypeNormalized(String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            LOG.error("The type cannot be empty or null");
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null or empty ");
        }
        this.normType = type.trim().toLowerCase();
        this.upType = type;
        this.upName = type + this.upName.substring(this.upName.indexOf(61));
        this.start = -1;
        this.length = this.upName.length();
    }

    public Object getNormValue() {
        return this.normValue;
    }

    public Object getUpValue() {
        return this.upValue;
    }

    public String getNormalizedValue() {
        return this.normalize();
    }

    public void setValue(Object upValue, Object normValue) {
        this.normValue = normValue instanceof String ? (StringTools.isEmpty((String)normValue) ? "" : (String)normValue) : normValue;
        this.upValue = upValue;
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + upValue;
        this.start = -1;
        this.length = this.upName.length();
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public String getUpName() {
        return this.upName;
    }

    public void setValueNormalized(String value) {
        String newValue = StringTools.trim(value);
        this.normValue = StringTools.isEmpty(newValue) ? "" : newValue;
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + value;
        this.start = -1;
        this.length = this.upName.length();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.normType, nc.normType);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.normValue, nc.normValue, true);
        }
        return 1;
    }

    public int compareToIgnoreCase(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.normType, nc.normType);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.normValue, nc.normValue, false);
        }
        return 1;
    }

    private int compareType(String val1, String val2) {
        if (StringTools.isEmpty(val1)) {
            return StringTools.isEmpty(val2) ? 0 : -1;
        }
        if (StringTools.isEmpty(val2)) {
            return 1;
        }
        return StringTools.trim(val1).compareToIgnoreCase(StringTools.trim(val2));
    }

    private int compareValue(Object val1, Object val2, boolean sensitivity) {
        if (val1 instanceof String) {
            if (val2 instanceof String) {
                int val;
                int n = val = sensitivity ? ((String)val1).compareTo((String)val2) : ((String)val1).compareToIgnoreCase((String)val2);
                return val < 0 ? -1 : (val > 0 ? 1 : val);
            }
            return 1;
        }
        if (val1 instanceof byte[]) {
            if (Arrays.equals((byte[])val1, (byte[])val2)) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public String normalize() {
        if (this.normValue instanceof String) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.normType).append('=');
            String normalizedValue = (String)this.normValue;
            int valueLength = normalizedValue.length();
            boolean escaped = false;
            if (normalizedValue.length() > 0) {
                char[] chars;
                for (char c : chars = normalizedValue.toCharArray()) {
                    if (c < '\u0000' || c > '\u0080') {
                        escaped = true;
                        break;
                    }
                    if (!DN_ESCAPED_CHARS[c]) continue;
                    escaped = true;
                    break;
                }
                if (escaped) {
                    for (int i = 0; i < valueLength; ++i) {
                        char c = chars[i];
                        if (c < '\u0000' || c > '\u0080') {
                            byte[] bb;
                            for (byte b : bb = StringTools.getBytesUtf8(normalizedValue.substring(i, i + 1))) {
                                sb.append('\\').append(StringTools.dumpHex((byte)((b & 0xF0) >> 4))).append(StringTools.dumpHex(b));
                            }
                            continue;
                        }
                        if (DN_ESCAPED_CHARS[c]) {
                            if (c == ' ') {
                                if (i == 0 || i == valueLength - 1) {
                                    sb.append('\\').append(c);
                                    continue;
                                }
                                sb.append(' ');
                                continue;
                            }
                            if (c == '#') {
                                if (i == 0) {
                                    sb.append("\\#");
                                    continue;
                                }
                                sb.append('#');
                                continue;
                            }
                            sb.append('\\').append(c);
                            continue;
                        }
                        sb.append(c);
                    }
                } else {
                    sb.append(normalizedValue);
                }
            }
            return sb.toString();
        }
        return this.normType + "=#" + StringTools.dumpHexPairs((byte[])this.normValue);
    }

    public int hashCode() {
        int result = 37;
        result = result * 17 + (this.normType != null ? this.normType.hashCode() : 0);
        result = result * 17 + (this.normValue != null ? this.normValue.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeTypeAndValue)) {
            return false;
        }
        AttributeTypeAndValue instance = (AttributeTypeAndValue)obj;
        if (this.normType == null ? instance.normType != null : !this.normType.equals(instance.normType)) {
            return false;
        }
        if (this.normValue == null) {
            return instance.normValue == null;
        }
        if (this.normValue instanceof String) {
            if (instance.normValue instanceof String) {
                return this.normValue.equals(instance.normValue);
            }
            return false;
        }
        if (this.normValue instanceof byte[]) {
            if (instance.normValue instanceof byte[]) {
                return Arrays.equals((byte[])this.normValue, (byte[])instance.normValue);
            }
            return false;
        }
        return false;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (StringTools.isEmpty(this.upName) || StringTools.isEmpty(this.upType) || StringTools.isEmpty(this.normType) || this.start < 0 || this.length < 2 || this.upValue == null || this.normValue == null) {
            String message = "Cannot serialize an wrong ATAV, ";
            if (StringTools.isEmpty(this.upName)) {
                message = message + "the upName should not be null or empty";
            } else if (StringTools.isEmpty(this.upType)) {
                message = message + "the upType should not be null or empty";
            } else if (StringTools.isEmpty(this.normType)) {
                message = message + "the normType should not be null or empty";
            } else if (this.start < 0) {
                message = message + "the start should not be < 0";
            } else if (this.length < 2) {
                message = message + "the length should not be < 2";
            } else if (this.upValue == null) {
                message = message + "the upValue should not be null";
            } else if (this.normValue == null) {
                message = message + "the value should not be null";
            }
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(this.upName);
        out.writeInt(this.start);
        out.writeInt(this.length);
        out.writeUTF(this.upType);
        out.writeUTF(this.normType);
        boolean isHR = this.normValue instanceof String;
        out.writeBoolean(isHR);
        if (isHR) {
            out.writeUTF((String)this.upValue);
            out.writeUTF((String)this.normValue);
        } else {
            out.writeInt(((byte[])this.upValue).length);
            out.write((byte[])this.upValue);
            out.writeInt(((byte[])this.normValue).length);
            out.write((byte[])this.normValue);
        }
        out.flush();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.upName = in.readUTF();
        this.start = in.readInt();
        this.length = in.readInt();
        this.upType = in.readUTF();
        this.normType = in.readUTF();
        boolean isHR = in.readBoolean();
        if (isHR) {
            this.upValue = in.readUTF();
            this.normValue = in.readUTF();
        } else {
            int upValueLength = in.readInt();
            this.upValue = new byte[upValueLength];
            in.readFully((byte[])this.upValue);
            int valueLength = in.readInt();
            this.normValue = new byte[valueLength];
            in.readFully((byte[])this.normValue);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (StringTools.isEmpty(this.normType) || StringTools.isEmpty(this.normType.trim())) {
            return "";
        }
        sb.append(this.normType).append("=");
        if (this.normValue != null) {
            sb.append(this.normValue);
        }
        return sb.toString();
    }
}

