/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Chars;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaIntegerSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(JavaIntegerSyntaxChecker.class);

    public JavaIntegerSyntaxChecker() {
        super("1.3.6.1.4.1.18060.0.4.1.0.4");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int pos = 0;
        char c = strValue.charAt(pos);
        if (c == '-') {
            pos = 1;
        } else {
            if (!Chars.isDigit((char)c)) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            if (c == '0') {
                boolean result;
                boolean bl = result = strValue.length() <= 1;
                if (result) {
                    LOG.debug("Syntax valid for '{}'", value);
                } else {
                    LOG.debug("Syntax invalid for '{}'", value);
                }
                return result;
            }
        }
        if (!Chars.isDigit((String)strValue, (int)pos)) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        if (Strings.isCharASCII((String)strValue, (int)pos, (char)'0')) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        ++pos;
        while (Chars.isDigit((String)strValue, (int)pos)) {
            ++pos;
        }
        if (pos != strValue.length()) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        try {
            Integer.valueOf(strValue);
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        catch (NumberFormatException e) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }
}

