/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.syntaxCheckers;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.model.schema.syntaxCheckers.TelephoneNumberSyntaxChecker;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacsimileTelephoneNumberSyntaxChecker
extends TelephoneNumberSyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(FacsimileTelephoneNumberSyntaxChecker.class);
    private static final String TWO_DIMENSIONAL = "twoDimensional";
    private static final String FINE_RESOLUTION = "fineResolution";
    private static final String UNLIMITED_LENGTH = "unlimitedLength";
    private static final String B4_LENGTH = "b4Length";
    private static final String A3_LENGTH = "a3Width";
    private static final String B4_WIDTH = "b4Width";
    private static final String UNCOMPRESSED = "uncompressed";
    private static Set<String> faxParameters = new HashSet<String>();

    public FacsimileTelephoneNumberSyntaxChecker() {
        this.setOid("1.3.6.1.4.1.1466.115.121.1.22");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int dollarPos = strValue.indexOf(36);
        if (dollarPos == -1) {
            boolean result = super.isValidSyntax(strValue);
            if (result) {
                LOG.debug("Syntax valid for '{}'", value);
            } else {
                LOG.debug("Syntax invalid for '{}'", value);
            }
            return result;
        }
        if (dollarPos > 0) {
            if (!super.isValidSyntax(strValue.substring(0, dollarPos - 1))) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            HashSet<String> paramsSeen = new HashSet<String>();
            while (dollarPos > 0) {
                String faxParam = null;
                int newDollar = strValue.indexOf(36, dollarPos + 1);
                faxParam = newDollar == -1 ? strValue.substring(dollarPos + 1) : strValue.substring(dollarPos + 1, newDollar);
                if (faxParam == null) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                if (!faxParameters.contains(faxParam = faxParam.toLowerCase())) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                if (paramsSeen.contains(faxParam)) {
                    LOG.debug("Syntax invalid for '{}'", value);
                    return false;
                }
                paramsSeen.add(faxParam);
                dollarPos = newDollar;
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        LOG.debug("Syntax invalid for '{}'", value);
        return false;
    }

    static {
        faxParameters.add(TWO_DIMENSIONAL.toLowerCase());
        faxParameters.add(FINE_RESOLUTION.toLowerCase());
        faxParameters.add(UNLIMITED_LENGTH.toLowerCase());
        faxParameters.add(B4_LENGTH.toLowerCase());
        faxParameters.add(A3_LENGTH.toLowerCase());
        faxParameters.add(B4_WIDTH.toLowerCase());
        faxParameters.add(UNCOMPRESSED.toLowerCase());
    }
}

