/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message.controls;

import org.apache.directory.shared.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChangeType {
    ADD(1),
    DELETE(2),
    MODIFY(4),
    MODDN(8);

    private int value;

    private ChangeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean presentIn(int changeTypes) {
        return this.value == (this.value & changeTypes);
    }

    public static ChangeType getChangeType(int value) {
        switch (value) {
            case 1: {
                return ADD;
            }
            case 2: {
                return DELETE;
            }
            case 4: {
                return MODIFY;
            }
            case 8: {
                return MODDN;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04055, (Object[])new Object[]{value}));
    }
}

