/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.filter;

import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.AttributeUtils;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.ApproximateNode;
import org.apache.directory.shared.ldap.model.filter.BranchNode;
import org.apache.directory.shared.ldap.model.filter.EqualityNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.model.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.model.filter.LessEqNode;
import org.apache.directory.shared.ldap.model.filter.NotNode;
import org.apache.directory.shared.ldap.model.filter.OrNode;
import org.apache.directory.shared.ldap.model.filter.PresenceNode;
import org.apache.directory.shared.ldap.model.filter.SubstringNode;
import org.apache.directory.shared.ldap.model.filter.UndefinedNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Chars;
import org.apache.directory.shared.util.Hex;
import org.apache.directory.shared.util.Position;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.Unicode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExprNode parseExtensible(SchemaManager schemaManager, String attribute, String filter, Position pos) throws LdapException, ParseException {
        ExtensibleNode node = null;
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.getAttributeType(attribute);
            if (attributeType == null) return UndefinedNode.UNDEFINED_NODE;
            node = new ExtensibleNode(attributeType);
        } else {
            node = new ExtensibleNode(attribute);
        }
        if (attribute != null) {
            if (Strings.areEquals((String)filter, (int)pos.start, (String)"dn")) {
                node.setDnAttributes(true);
                pos.start += 2;
            } else {
                --pos.start;
            }
            if (Strings.charAt((String)filter, (int)pos.start) != ':') throw new ParseException(I18n.err((I18n)I18n.ERR_04147, (Object[])new Object[0]), pos.start);
            ++pos.start;
            int start = pos.start;
            if (Strings.charAt((String)filter, (int)pos.start) == '=') {
                ++pos.start;
                node.setValue(FilterParser.parseAssertionValue(filter, pos));
                return node;
            }
            AttributeUtils.parseAttribute(filter, pos, false);
            node.setMatchingRuleId(filter.substring(start, pos.start));
            if (!Strings.areEquals((String)filter, (int)pos.start, (String)":=")) throw new ParseException(I18n.err((I18n)I18n.ERR_04146, (Object[])new Object[0]), pos.start);
            pos.start += 2;
            node.setValue(FilterParser.parseAssertionValue(filter, pos));
            return node;
        }
        boolean oidRequested = false;
        if (Strings.areEquals((String)filter, (int)pos.start, (String)":dn")) {
            node.setDnAttributes(true);
            pos.start += 3;
        } else {
            oidRequested = true;
        }
        if (Strings.charAt((String)filter, (int)pos.start) != ':') throw new ParseException(I18n.err((I18n)I18n.ERR_04147, (Object[])new Object[0]), pos.start);
        ++pos.start;
        int start = pos.start;
        if (Strings.charAt((String)filter, (int)pos.start) == '=') {
            if (oidRequested) {
                throw new ParseException(I18n.err((I18n)I18n.ERR_04148, (Object[])new Object[0]), pos.start);
            }
            ++pos.start;
            node.setValue(FilterParser.parseAssertionValue(filter, pos));
            return node;
        }
        AttributeUtils.parseAttribute(filter, pos, false);
        node.setMatchingRuleId(filter.substring(start, pos.start));
        if (!Strings.areEquals((String)filter, (int)pos.start, (String)":=")) throw new ParseException(I18n.err((I18n)I18n.ERR_04146, (Object[])new Object[0]), pos.start);
        pos.start += 2;
        node.setValue(FilterParser.parseAssertionValue(filter, pos));
        return node;
    }

    private static Value<?> parseAssertionValue(String filter, Position pos) throws ParseException {
        char c = Strings.charAt((String)filter, (int)pos.start);
        byte[] value = new byte[filter.length() - pos.start];
        int current = 0;
        do {
            if (Unicode.isUnicodeSubset((char)c)) {
                value[current++] = (byte)c;
                ++pos.start;
                continue;
            }
            if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)'\\')) break;
            ++pos.start;
            if (Chars.isHex((String)filter, (int)pos.start)) {
                ++pos.start;
            } else {
                throw new ParseException(I18n.err((I18n)I18n.ERR_04149, (Object[])new Object[0]), pos.start);
            }
            if (Chars.isHex((String)filter, (int)pos.start)) {
                value[current++] = Hex.getHexValue((char)filter.charAt(pos.start - 1), (char)filter.charAt(pos.start));
                ++pos.start;
                continue;
            }
            throw new ParseException(I18n.err((I18n)I18n.ERR_04149, (Object[])new Object[0]), pos.start);
        } while ((c = Strings.charAt((String)filter, (int)pos.start)) != '\u0000');
        if (current != 0) {
            byte[] result = new byte[current];
            System.arraycopy(value, 0, result, 0, current);
            return new BinaryValue(result);
        }
        return new BinaryValue((byte[])null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExprNode parseSubstring(SchemaManager schemaManager, String attribute, Value<?> initial, String filter, Position pos) throws ParseException, LdapException {
        if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)'*')) throw new ParseException(I18n.err((I18n)I18n.ERR_04150, (Object[])new Object[0]), pos.start);
        SubstringNode node = null;
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(attribute);
            if (attributeType == null) return null;
            node = new SubstringNode(schemaManager.lookupAttributeTypeRegistry(attribute));
        } else {
            node = new SubstringNode(attribute);
        }
        if (initial != null && !initial.isNull()) {
            String initialStr = initial.getString();
            node.setInitial(initialStr);
        }
        ++pos.start;
        while (true) {
            Value<?> assertionValue = FilterParser.parseAssertionValue(filter, pos);
            if (Strings.isCharASCII((String)filter, (int)pos.start, (char)')')) {
                if (assertionValue.isNull()) return node;
                String finalStr = assertionValue.getString();
                node.setFinal(finalStr);
                return node;
            }
            if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)'*')) throw new ParseException(I18n.err((I18n)I18n.ERR_04150, (Object[])new Object[0]), pos.start);
            if (!assertionValue.isNull()) {
                String anyStr = assertionValue.getString();
                node.addAny(anyStr);
            }
            ++pos.start;
        }
    }

    private static ExprNode parsePresenceEqOrSubstring(SchemaManager schemaManager, String attribute, String filter, Position pos) throws ParseException, LdapException {
        if (Strings.isCharASCII((String)filter, (int)pos.start, (char)'*')) {
            ++pos.start;
            if (Strings.isCharASCII((String)filter, (int)pos.start, (char)')')) {
                if (schemaManager != null) {
                    AttributeType attributeType = schemaManager.getAttributeType(attribute);
                    if (attributeType != null) {
                        return new PresenceNode(attributeType);
                    }
                    return null;
                }
                return new PresenceNode(attribute);
            }
            --pos.start;
            return FilterParser.parseSubstring(schemaManager, attribute, null, filter, pos);
        }
        if (Strings.isCharASCII((String)filter, (int)pos.start, (char)')')) {
            if (schemaManager != null) {
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new EqualityNode<byte[]>(attributeType, new BinaryValue((byte[])null));
                }
                return null;
            }
            return new EqualityNode<byte[]>(attribute, new BinaryValue((byte[])null));
        }
        Value<?> value = FilterParser.parseAssertionValue(filter, pos);
        if (Strings.isCharASCII((String)filter, (int)pos.start, (char)')')) {
            if (schemaManager != null) {
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new EqualityNode(attributeType, value);
                }
                return null;
            }
            return new EqualityNode(attribute, value);
        }
        return FilterParser.parseSubstring(schemaManager, attribute, value, filter, pos);
    }

    private static ExprNode parseItem(SchemaManager schemaManager, String filter, Position pos, char c) throws ParseException, LdapException {
        String attribute = null;
        if (c == '\u0000') {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04151, (Object[])new Object[0]), pos.start);
        }
        if (c == ':') {
            return FilterParser.parseExtensible(schemaManager, null, filter, pos);
        }
        attribute = AttributeUtils.parseAttribute(filter, pos, true);
        c = Strings.charAt((String)filter, (int)pos.start);
        switch (c) {
            case '=': {
                ++pos.start;
                return FilterParser.parsePresenceEqOrSubstring(schemaManager, attribute, filter, pos);
            }
            case '~': {
                ++pos.start;
                if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)'=')) {
                    throw new ParseException(I18n.err((I18n)I18n.ERR_04152, (Object[])new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new ApproximateNode(attribute, FilterParser.parseAssertionValue(filter, pos));
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new ApproximateNode(attributeType, FilterParser.parseAssertionValue(filter, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case '>': {
                ++pos.start;
                if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)'=')) {
                    throw new ParseException(I18n.err((I18n)I18n.ERR_04152, (Object[])new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new GreaterEqNode(attribute, FilterParser.parseAssertionValue(filter, pos));
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new GreaterEqNode(attributeType, FilterParser.parseAssertionValue(filter, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case '<': {
                ++pos.start;
                if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)'=')) {
                    throw new ParseException(I18n.err((I18n)I18n.ERR_04152, (Object[])new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new LessEqNode(attribute, FilterParser.parseAssertionValue(filter, pos));
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new LessEqNode(attributeType, FilterParser.parseAssertionValue(filter, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case ':': {
                ++pos.start;
                return FilterParser.parseExtensible(schemaManager, attribute, filter, pos);
            }
        }
        throw new ParseException(I18n.err((I18n)I18n.ERR_04153, (Object[])new Object[0]), pos.start);
    }

    private static ExprNode parseBranchNode(SchemaManager schemaManager, ExprNode node, String filter, Position pos) throws ParseException, LdapException {
        BranchNode branchNode = (BranchNode)node;
        int nbChildren = 0;
        ExprNode child = FilterParser.parseFilterInternal(schemaManager, filter, pos);
        if (child != UndefinedNode.UNDEFINED_NODE) {
            branchNode.addNode(child);
            if (branchNode instanceof NotNode) {
                return node;
            }
            ++nbChildren;
        } else if (node instanceof AndNode) {
            return UndefinedNode.UNDEFINED_NODE;
        }
        while ((child = FilterParser.parseFilterInternal(schemaManager, filter, pos)) != UndefinedNode.UNDEFINED_NODE) {
            if (child != null) {
                branchNode.addNode(child);
                ++nbChildren;
                continue;
            }
            if (!(node instanceof AndNode)) continue;
            return UndefinedNode.UNDEFINED_NODE;
        }
        if (nbChildren > 0) {
            return node;
        }
        return UndefinedNode.UNDEFINED_NODE;
    }

    private static ExprNode parseFilterComp(SchemaManager schemaManager, String filter, Position pos) throws ParseException, LdapException {
        ExprNode node = null;
        if (pos.start == pos.length) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04154, (Object[])new Object[0]), pos.start);
        }
        char c = Strings.charAt((String)filter, (int)pos.start);
        switch (c) {
            case '&': {
                ++pos.start;
                node = new AndNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filter, pos);
                break;
            }
            case '|': {
                ++pos.start;
                node = new OrNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filter, pos);
                break;
            }
            case '!': {
                ++pos.start;
                node = new NotNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filter, pos);
                break;
            }
            default: {
                node = FilterParser.parseItem(schemaManager, filter, pos, c);
            }
        }
        return node;
    }

    private static ExprNode parseFilterInternal(SchemaManager schemaManager, String filter, Position pos) throws ParseException, LdapException {
        if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)'(')) {
            if (pos.start == 0 && pos.length != 0) {
                throw new ParseException(I18n.err((I18n)I18n.ERR_04155, (Object[])new Object[0]), 0);
            }
            return UndefinedNode.UNDEFINED_NODE;
        }
        ++pos.start;
        ExprNode node = FilterParser.parseFilterComp(schemaManager, filter, pos);
        if (node == UndefinedNode.UNDEFINED_NODE) {
            return UndefinedNode.UNDEFINED_NODE;
        }
        if (!Strings.isCharASCII((String)filter, (int)pos.start, (char)')')) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04157, (Object[])new Object[0]), pos.start);
        }
        ++pos.start;
        return node;
    }

    public static ExprNode parse(String filter) throws ParseException {
        return FilterParser.parse(null, filter);
    }

    public static ExprNode parse(SchemaManager schemaManager, String filter) throws ParseException {
        if (Strings.isEmpty((String)filter)) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04158, (Object[])new Object[0]), 0);
        }
        Position pos = new Position();
        pos.start = 0;
        pos.end = 0;
        pos.length = filter.length();
        try {
            return FilterParser.parseFilterInternal(schemaManager, filter, pos);
        }
        catch (LdapException le) {
            throw new ParseException(le.getMessage(), pos.start);
        }
    }

    public static ExprNode parse(SchemaManager schemaManager, String filter, Position pos) throws ParseException {
        if (Strings.isEmpty((String)filter)) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_04158, (Object[])new Object[0]), 0);
        }
        pos.start = 0;
        pos.end = 0;
        pos.length = filter.length();
        try {
            return FilterParser.parseFilterInternal(schemaManager, filter, pos);
        }
        catch (LdapException le) {
            throw new ParseException(le.getMessage(), pos.start);
        }
    }
}

