/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValue<T>
implements Value<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractValue.class);
    protected transient AttributeType attributeType;
    protected T wrappedValue;
    protected T normalizedValue;
    protected volatile int h;

    @Override
    public Value<T> clone() {
        try {
            return (Value)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public T getReference() {
        return this.wrappedValue;
    }

    @Override
    public String getString() {
        throw new UnsupportedOperationException("Cannot call this method on a binary value");
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException("Cannot call this method on a String value");
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void apply(AttributeType attributeType) throws LdapInvalidAttributeValueException {
        block10: {
            block11: {
                if (attributeType == null) {
                    this.normalizedValue = this.wrappedValue;
                    return;
                }
                this.attributeType = attributeType;
                MatchingRule equality = attributeType.getEquality();
                if (equality == null) break block11;
                Normalizer normalizer = equality.getNormalizer();
                if (normalizer == null) {
                    String message = "The '" + attributeType.getName() + "' AttributeType does not have" + " a normalizer";
                    LOG.error(message);
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                if (this.wrappedValue != null) {
                    boolean isHR = attributeType.getSyntax().isHumanReadable();
                    if (isHR != this.isHumanReadable()) {
                        String message = "The '" + attributeType.getName() + "' AttributeType and values must " + "both be String or binary";
                        LOG.error(message);
                        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    try {
                        if (this.isHumanReadable()) {
                            this.normalizedValue = normalizer.normalize((String)this.wrappedValue);
                            break block10;
                        }
                        this.normalizedValue = normalizer.normalize(new BinaryValue((byte[])this.wrappedValue)).getNormReference();
                    }
                    catch (LdapException ne) {
                        String message = I18n.err((I18n)I18n.ERR_04447_CANNOT_NORMALIZE_VALUE, (Object[])new Object[]{ne.getLocalizedMessage()});
                        LOG.info(message);
                    }
                }
                break block10;
            }
            this.normalizedValue = this.wrappedValue;
        }
        try {
            LdapSyntax syntax = attributeType.getSyntax();
            if (syntax != null && !this.isValid(syntax.getSyntaxChecker())) {
                String message = I18n.err((I18n)I18n.ERR_04473_NOT_VALID_VALUE, (Object[])new Object[]{this.wrappedValue, attributeType});
                LOG.info(message);
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        catch (LdapException le) {
            String message = I18n.err((I18n)I18n.ERR_04447_CANNOT_NORMALIZE_VALUE, (Object[])new Object[]{le.getLocalizedMessage()});
            LOG.info(message);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message, le);
        }
        this.h = 0;
        this.hashCode();
    }

    protected final LdapComparator<T> getLdapComparator() throws LdapException {
        MatchingRule mr;
        if (this.attributeType != null && (mr = this.attributeType.getEquality()) != null) {
            return mr.getLdapComparator();
        }
        return null;
    }

    @Override
    public boolean isInstanceOf(AttributeType attributeType) {
        return attributeType != null && (this.attributeType.equals(attributeType) || this.attributeType.isDescendantOf(attributeType));
    }

    @Override
    public T getNormReference() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return this.wrappedValue;
        }
        return this.normalizedValue;
    }

    @Override
    public final boolean isNull() {
        return this.wrappedValue == null;
    }

    @Override
    public final boolean isValid(SyntaxChecker syntaxChecker) throws LdapInvalidAttributeValueException {
        if (syntaxChecker == null) {
            String message = I18n.err((I18n)I18n.ERR_04139, (Object[])new Object[]{this.toString()});
            LOG.error(message);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return syntaxChecker.isValidSyntax(this.normalizedValue);
    }

    @Override
    public final boolean isSchemaAware() {
        return this.attributeType != null;
    }
}

