/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl.storedProcedure;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.extras.extended.StoredProcedureParameter;
import org.apache.directory.shared.ldap.extras.extended.StoredProcedureRequest;
import org.apache.directory.shared.ldap.extras.extended.StoredProcedureRequestImpl;
import org.apache.directory.shared.ldap.extras.extended.StoredProcedureResponse;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureDecoder;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureRequestDecorator
extends ExtendedRequestDecorator<StoredProcedureRequest, StoredProcedureResponse>
implements StoredProcedureRequest {
    private static final Logger LOG = LoggerFactory.getLogger(StoredProcedureRequestDecorator.class);
    private StoredProcedureParameter currentParameter;
    private int storedProcedureLength;
    private int parametersLength;
    private List<Integer> parameterLength;
    private List<Integer> paramTypeLength;
    private List<Integer> paramValueLength;

    public StoredProcedureRequestDecorator(LdapApiService codec) {
        super(codec, (ExtendedRequest)new StoredProcedureRequestImpl());
    }

    public StoredProcedureRequestDecorator(LdapApiService codec, StoredProcedureRequest decoratedRequest) {
        super(codec, (ExtendedRequest)decoratedRequest);
        if (decoratedRequest == null) {
            throw new NullPointerException("decorated stored procedulre request is null");
        }
    }

    public StoredProcedureParameter getCurrentParameter() {
        return this.currentParameter;
    }

    public void setCurrentParameter(StoredProcedureParameter currentParameter) {
        this.currentParameter = currentParameter;
    }

    public int computeLength() {
        byte[] languageBytes = Strings.getBytesUtf8((String)((StoredProcedureRequest)this.getDecorated()).getLanguage());
        int languageLength = 1 + TLV.getNbBytes((int)languageBytes.length) + languageBytes.length;
        byte[] procedure = ((StoredProcedureRequest)this.getDecorated()).getProcedure();
        int procedureLength = 1 + TLV.getNbBytes((int)procedure.length) + procedure.length;
        if (((StoredProcedureRequest)this.getDecorated()).getParameters() != null) {
            this.parameterLength = new LinkedList<Integer>();
            this.paramTypeLength = new LinkedList<Integer>();
            this.paramValueLength = new LinkedList<Integer>();
            for (StoredProcedureParameter spParam : ((StoredProcedureRequest)this.getDecorated()).getParameters()) {
                int localParameterLength = 0;
                int localParamTypeLength = 0;
                int localParamValueLength = 0;
                localParamTypeLength = 1 + TLV.getNbBytes((int)spParam.getType().length) + spParam.getType().length;
                localParamValueLength = 1 + TLV.getNbBytes((int)spParam.getValue().length) + spParam.getValue().length;
                localParameterLength = localParamTypeLength + localParamValueLength;
                this.parametersLength += 1 + TLV.getNbBytes((int)localParameterLength) + localParameterLength;
                this.parameterLength.add(localParameterLength);
                this.paramTypeLength.add(localParamTypeLength);
                this.paramValueLength.add(localParamValueLength);
            }
        }
        int localParametersLength = 1 + TLV.getNbBytes((int)this.parametersLength) + this.parametersLength;
        this.storedProcedureLength = languageLength + procedureLength + localParametersLength;
        return 1 + TLV.getNbBytes((int)this.storedProcedureLength) + this.storedProcedureLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        try {
            bb.put(UniversalTag.SEQUENCE.getValue());
            bb.put(TLV.getBytes((int)this.storedProcedureLength));
            Value.encode((ByteBuffer)bb, (String)((StoredProcedureRequest)this.getDecorated()).getLanguage());
            Value.encode((ByteBuffer)bb, (byte[])((StoredProcedureRequest)this.getDecorated()).getProcedure());
            bb.put(UniversalTag.SEQUENCE.getValue());
            bb.put(TLV.getBytes((int)this.parametersLength));
            if (((StoredProcedureRequest)this.getDecorated()).getParameters() != null && ((StoredProcedureRequest)this.getDecorated()).getParameters().size() != 0) {
                int parameterNumber = 0;
                for (StoredProcedureParameter spParam : ((StoredProcedureRequest)this.getDecorated()).getParameters()) {
                    bb.put(UniversalTag.SEQUENCE.getValue());
                    int localParameterLength = this.parameterLength.get(parameterNumber);
                    bb.put(TLV.getBytes((int)localParameterLength));
                    Value.encode((ByteBuffer)bb, (byte[])spParam.getType());
                    Value.encode((ByteBuffer)bb, (byte[])spParam.getValue());
                    ++parameterNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    StoredProcedure\n");
        sb.append("        Language : '").append(((StoredProcedureRequest)this.getDecorated()).getLanguage()).append("'\n");
        sb.append("        Procedure\n").append(((StoredProcedureRequest)this.getDecorated()).getProcedureSpecification()).append("'\n");
        if (((StoredProcedureRequest)this.getDecorated()).getParameters() == null || ((StoredProcedureRequest)this.getDecorated()).getParameters().size() == 0) {
            sb.append("        No parameters\n");
        } else {
            sb.append("        Parameters\n");
            int i = 1;
            for (StoredProcedureParameter spParam : ((StoredProcedureRequest)this.getDecorated()).getParameters()) {
                sb.append("            type[").append(i).append("] : '").append(Strings.utf8ToString((byte[])spParam.getType())).append("'\n");
                sb.append("            value[").append(i).append("] : '").append(Strings.dumpBytes((byte[])spParam.getValue())).append("'\n");
            }
        }
        return sb.toString();
    }

    public void setProcedure(byte[] procedure) {
        ((StoredProcedureRequest)this.getDecorated()).setProcedure(procedure);
    }

    public void setRequestValue(byte[] payload) {
        StoredProcedureDecoder decoder = new StoredProcedureDecoder();
        StoredProcedureContainer container = new StoredProcedureContainer();
        container.setStoredProcedure(this);
        try {
            decoder.decode(ByteBuffer.wrap(payload), (Asn1Container)container);
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04174, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public String getLanguage() {
        return ((StoredProcedureRequest)this.getDecorated()).getLanguage();
    }

    public void setLanguage(String language) {
        ((StoredProcedureRequest)this.getDecorated()).setLanguage(language);
    }

    public String getProcedureSpecification() {
        return ((StoredProcedureRequest)this.getDecorated()).getProcedureSpecification();
    }

    public int size() {
        return ((StoredProcedureRequest)this.getDecorated()).size();
    }

    public Object getParameterType(int index) {
        return ((StoredProcedureRequest)this.getDecorated()).getParameterType(index);
    }

    public Class<?> getJavaParameterType(int index) {
        return ((StoredProcedureRequest)this.getDecorated()).getJavaParameterType(index);
    }

    public Object getParameterValue(int index) {
        return ((StoredProcedureRequest)this.getDecorated()).getParameterValue(index);
    }

    public Object getJavaParameterValue(int index) {
        return ((StoredProcedureRequest)this.getDecorated()).getJavaParameterValue(index);
    }

    public void addParameter(Object type, Object value) {
        ((StoredProcedureRequest)this.getDecorated()).addParameter(type, value);
    }

    public byte[] getProcedure() {
        return ((StoredProcedureRequest)this.getDecorated()).getProcedure();
    }

    public List<StoredProcedureParameter> getParameters() {
        return ((StoredProcedureRequest)this.getDecorated()).getParameters();
    }

    public void addParameter(StoredProcedureParameter parameter) {
        ((StoredProcedureRequest)this.getDecorated()).addParameter(parameter);
    }
}

