/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnStatesEnum;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnTags;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncModifyDnGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(SyncModifyDnGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar instance = new SyncModifyDnGrammar();

    private SyncModifyDnGrammar() {
        this.setName(SyncModifyDnGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncModifyDnStatesEnum.LAST_SYNC_MODDN_VALUE_STATE.ordinal()][256];
        this.transitions[SyncModifyDnStatesEnum.START_SYNC_MODDN.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.START_SYNC_MODDN, (Enum)SyncModifyDnStatesEnum.SYNC_MODDN_VALUE_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SyncModifyDnStatesEnum.SYNC_MODDN_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.SYNC_MODDN_VALUE_SEQUENCE_STATE, (Enum)SyncModifyDnStatesEnum.ENTRY_DN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("Set SyncModifyDnControl entryDn value"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String entryDn = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("ModDN entryDn = {}", (Object)entryDn);
                }
                container.getSyncModifyDnControl().setEntryDn(entryDn);
                container.setGrammarEndAllowed(false);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.ENTRY_DN_STATE.ordinal()][SyncModifyDnTags.MOVE_TAG.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.ENTRY_DN_STATE, (Enum)SyncModifyDnStatesEnum.MOVE_STATE, SyncModifyDnTags.MOVE_TAG.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("Set SyncModifyDnControl newSuperiorDn"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                container.getSyncModifyDnControl().setModDnType(SyncModifyDnType.MOVE);
                Value value = container.getCurrentTLV().getValue();
                String newSuperiorDn = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("ModDN newSuperiorDn = {}", (Object)newSuperiorDn);
                }
                container.getSyncModifyDnControl().setNewSuperiorDn(newSuperiorDn);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.ENTRY_DN_STATE.ordinal()][SyncModifyDnTags.RENAME_TAG.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.ENTRY_DN_STATE, (Enum)SyncModifyDnStatesEnum.RENAME_STATE, SyncModifyDnTags.RENAME_TAG.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("enter SyncModifyDnControl rename choice"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                container.getSyncModifyDnControl().setModDnType(SyncModifyDnType.RENAME);
                container.setGrammarEndAllowed(false);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.RENAME_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.RENAME_STATE, (Enum)SyncModifyDnStatesEnum.RENAME_NEW_RDN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("Set SyncModifyDnControl newRdn value"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String newRdn = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("newRdn = {}", (Object)newRdn);
                }
                container.getSyncModifyDnControl().setNewRdn(newRdn);
                container.setGrammarEndAllowed(false);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.RENAME_NEW_RDN_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.RENAME_NEW_RDN_STATE, (Enum)SyncModifyDnStatesEnum.RENAME_DEL_OLD_RDN_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("Set SyncModifyDnControl deleteOldRdn value"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                byte deleteOldRdn = value.getData()[0];
                if (IS_DEBUG) {
                    LOG.debug("deleteOldRdn = {}", (Object)deleteOldRdn);
                }
                if (deleteOldRdn != 0) {
                    container.getSyncModifyDnControl().setDeleteOldRdn(true);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.ENTRY_DN_STATE.ordinal()][SyncModifyDnTags.MOVEANDRENAME_TAG.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.ENTRY_DN_STATE, (Enum)SyncModifyDnStatesEnum.MOVE_AND_RENAME_STATE, SyncModifyDnTags.MOVEANDRENAME_TAG.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("enter SyncModifyDnControl moveAndRename choice"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                container.getSyncModifyDnControl().setModDnType(SyncModifyDnType.MOVEANDRENAME);
                container.setGrammarEndAllowed(false);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.MOVE_AND_RENAME_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.MOVE_AND_RENAME_STATE, (Enum)SyncModifyDnStatesEnum.MOVE_AND_RENAME_NEW_SUPERIOR_DN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("Set SyncModifyDnControl moveAndRename state's newSuperirorDN value"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String newSuperirorDn = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("newSuperirorDn = {}", (Object)newSuperirorDn);
                }
                container.getSyncModifyDnControl().setNewSuperiorDn(newSuperirorDn);
                container.setGrammarEndAllowed(false);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.MOVE_AND_RENAME_NEW_SUPERIOR_DN_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.MOVE_AND_RENAME_NEW_SUPERIOR_DN_STATE, (Enum)SyncModifyDnStatesEnum.MOVE_AND_RENAME_NEW_RDN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("Set SyncModifyDnControl moveAndRename state's newRdn value"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String newRdn = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("newRdn = {}", (Object)newRdn);
                }
                container.getSyncModifyDnControl().setNewRdn(newRdn);
                container.setGrammarEndAllowed(false);
            }
        });
        this.transitions[SyncModifyDnStatesEnum.MOVE_AND_RENAME_NEW_RDN_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncModifyDnStatesEnum.MOVE_AND_RENAME_NEW_RDN_STATE, (Enum)SyncModifyDnStatesEnum.MOVE_AND_RENAME_DEL_OLD_RDN_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncModifyDnContainer>("Set SyncModifyDnControl deleteOldRdn value"){

            public void action(SyncModifyDnContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                byte deleteOldRdn = value.getData()[0];
                if (IS_DEBUG) {
                    LOG.debug("deleteOldRdn = {}", (Object)deleteOldRdn);
                }
                if (deleteOldRdn != 0) {
                    container.getSyncModifyDnControl().setDeleteOldRdn(true);
                }
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar getInstance() {
        return instance;
    }
}

