/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.controls.syncrepl_impl;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ControlDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDn;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnImpl;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnContainer;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnTags;
import org.apache.directory.shared.ldap.model.message.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncModifyDnDecorator
extends ControlDecorator<SyncModifyDn>
implements SyncModifyDn {
    private String entryDn;
    private String newSuperiorDn;
    private String newRdn;
    private boolean deleteOldRdn = false;
    private SyncModifyDnType modDnType;
    private int syncModDnSeqLength;
    private int renameLen = 0;
    private int moveAndRenameLen = 0;
    private Asn1Decoder decoder = new Asn1Decoder();

    public SyncModifyDnDecorator(LdapApiService codec) {
        super(codec, (Control)new SyncModifyDnImpl());
    }

    public SyncModifyDnDecorator(LdapApiService codec, SyncModifyDnType type) {
        this(codec);
        this.modDnType = type;
    }

    public SyncModifyDnDecorator(LdapApiService codec, SyncModifyDn control) {
        super(codec, (Control)control);
    }

    public int computeLength() {
        this.syncModDnSeqLength = 1 + TLV.getNbBytes((int)this.entryDn.length()) + this.entryDn.length();
        switch (this.modDnType) {
            case MOVE: {
                int moveLen = 1 + TLV.getNbBytes((int)this.newSuperiorDn.length()) + this.newSuperiorDn.length();
                this.syncModDnSeqLength += moveLen;
                break;
            }
            case RENAME: {
                this.renameLen = 1 + TLV.getNbBytes((int)this.newRdn.length()) + this.newRdn.length();
                this.renameLen += 3;
                this.syncModDnSeqLength += 1 + TLV.getNbBytes((int)this.renameLen) + this.renameLen;
                break;
            }
            case MOVEANDRENAME: {
                this.moveAndRenameLen = 1 + TLV.getNbBytes((int)this.newSuperiorDn.length()) + this.newSuperiorDn.length();
                this.moveAndRenameLen += 1 + TLV.getNbBytes((int)this.newRdn.length()) + this.newRdn.length();
                this.moveAndRenameLen += 3;
                this.syncModDnSeqLength += 1 + TLV.getNbBytes((int)this.moveAndRenameLen) + this.moveAndRenameLen;
            }
        }
        this.valueLength = 1 + TLV.getNbBytes((int)this.syncModDnSeqLength) + this.syncModDnSeqLength;
        return this.valueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.syncModDnSeqLength));
        Value.encode((ByteBuffer)buffer, (String)this.entryDn);
        switch (this.modDnType) {
            case MOVE: {
                buffer.put((byte)SyncModifyDnTags.MOVE_TAG.getValue());
                buffer.put(TLV.getBytes((int)this.newSuperiorDn.length()));
                buffer.put(Asn1StringUtils.getBytesUtf8((String)this.newSuperiorDn));
                break;
            }
            case RENAME: {
                buffer.put((byte)SyncModifyDnTags.RENAME_TAG.getValue());
                buffer.put(TLV.getBytes((int)this.renameLen));
                Value.encode((ByteBuffer)buffer, (String)this.newRdn);
                Value.encode((ByteBuffer)buffer, (boolean)this.deleteOldRdn);
                break;
            }
            case MOVEANDRENAME: {
                buffer.put((byte)SyncModifyDnTags.MOVEANDRENAME_TAG.getValue());
                buffer.put(TLV.getBytes((int)this.moveAndRenameLen));
                Value.encode((ByteBuffer)buffer, (String)this.newSuperiorDn);
                Value.encode((ByteBuffer)buffer, (String)this.newRdn);
                Value.encode((ByteBuffer)buffer, (boolean)this.deleteOldRdn);
            }
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes((int)this.syncModDnSeqLength));
                Value.encode((ByteBuffer)buffer, (String)this.entryDn);
                switch (this.modDnType) {
                    case MOVE: {
                        buffer.put((byte)SyncModifyDnTags.MOVE_TAG.getValue());
                        buffer.put(TLV.getBytes((int)this.newSuperiorDn.length()));
                        buffer.put(Asn1StringUtils.getBytesUtf8((String)this.newSuperiorDn));
                        break;
                    }
                    case RENAME: {
                        buffer.put((byte)SyncModifyDnTags.RENAME_TAG.getValue());
                        buffer.put(TLV.getBytes((int)this.renameLen));
                        Value.encode((ByteBuffer)buffer, (String)this.newRdn);
                        Value.encode((ByteBuffer)buffer, (boolean)this.deleteOldRdn);
                        break;
                    }
                    case MOVEANDRENAME: {
                        buffer.put((byte)SyncModifyDnTags.MOVEANDRENAME_TAG.getValue());
                        buffer.put(TLV.getBytes((int)this.moveAndRenameLen));
                        Value.encode((ByteBuffer)buffer, (String)this.newSuperiorDn);
                        Value.encode((ByteBuffer)buffer, (String)this.newRdn);
                        Value.encode((ByteBuffer)buffer, (boolean)this.deleteOldRdn);
                    }
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public String getEntryDn() {
        return this.entryDn;
    }

    public void setEntryDn(String entryDn) {
        this.entryDn = entryDn;
    }

    public String getNewSuperiorDn() {
        return this.newSuperiorDn;
    }

    public void setNewSuperiorDn(String newSuperiorDn) {
        this.newSuperiorDn = newSuperiorDn;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public SyncModifyDnType getModDnType() {
        return this.modDnType;
    }

    public void setModDnType(SyncModifyDnType modDnType) {
        if (this.modDnType != null) {
            throw new IllegalStateException("cannot overwrite the existing modDnType value");
        }
        this.modDnType = modDnType;
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        SyncModifyDnContainer container = new SyncModifyDnContainer(this);
        this.decoder.decode(bb, (Asn1Container)container);
        return this;
    }
}

