/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LdapSecurityConstants {
    HASH_METHOD_SHA("sha"),
    HASH_METHOD_SSHA("ssha"),
    HASH_METHOD_MD5("md5"),
    HASH_METHOD_SMD5("smd5"),
    HASH_METHOD_CRYPT("crypt");

    private String name;

    private LdapSecurityConstants(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static LdapSecurityConstants getAlgorithm(String name) {
        String algorithm;
        String string = algorithm = name == null ? "" : name.toLowerCase();
        if (HASH_METHOD_SHA.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA;
        }
        if (HASH_METHOD_SSHA.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA;
        }
        if (HASH_METHOD_MD5.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_MD5;
        }
        if (HASH_METHOD_SMD5.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SMD5;
        }
        if (HASH_METHOD_CRYPT.getName().equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_CRYPT;
        }
        return null;
    }
}

