/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.tlv;

import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.primitives.BitString;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;

public class Value
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 1L;
    private byte[] data;
    private int currentPos;
    public static final byte TRUE_VALUE = -1;
    public static final byte FALSE_VALUE = 0;
    private static final byte[] ENCODED_TRUE = new byte[]{1, 1, -1};
    private static final byte[] ENCODED_FALSE = new byte[]{1, 1, 0};
    private static final int ONE_BYTE_MAX = 127;
    private static final int ONE_BYTE_MIN = -128;
    private static final int TWO_BYTE_MAX = Short.MAX_VALUE;
    private static final int TWO_BYTE_MIN = Short.MIN_VALUE;
    private static final int THREE_BYTE_MAX = 0x7FFFFF;
    private static final int THREE_BYTE_MIN = -8388608;

    public Value(byte[] value) {
        this.data = new byte[value.length];
        System.arraycopy(value, 0, this.data, 0, value.length);
        this.currentPos = 0;
    }

    public Value() {
        this.data = null;
        this.currentPos = 0;
    }

    public void init(int size) {
        this.data = new byte[size];
        this.currentPos = 0;
    }

    public void reset() {
        this.data = null;
        this.currentPos = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        int length = data.remaining();
        data.get(this.data, 0, length);
        this.currentPos = length;
    }

    public void addData(ByteBuffer data) {
        int length = data.remaining();
        data.get(this.data, this.currentPos, length);
        this.currentPos += length;
    }

    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, data.length);
        this.currentPos = data.length;
    }

    public void addData(byte[] data) {
        System.arraycopy(data, 0, this.data, this.currentPos, data.length);
        this.currentPos = data.length;
    }

    public int getCurrentLength() {
        return this.currentPos;
    }

    public static int getNbBytes(int value) {
        if (value >= -128 && value <= 127) {
            return 1;
        }
        if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return 2;
        }
        if (value >= -8388608 && value <= 0x7FFFFF) {
            return 3;
        }
        return 4;
    }

    public static byte[] getBytes(int value) {
        byte[] bytes = null;
        if (value >= 0) {
            if (value >= 0 && value <= 127) {
                bytes = new byte[]{(byte)value};
            } else if (value > 127 && value <= Short.MAX_VALUE) {
                bytes = new byte[2];
                bytes[1] = (byte)value;
                bytes[0] = (byte)(value >> 8);
            } else if (value > Short.MAX_VALUE && value <= 0x7FFFFF) {
                bytes = new byte[3];
                bytes[2] = (byte)value;
                bytes[1] = (byte)(value >> 8);
                bytes[0] = (byte)(value >> 16);
            } else {
                bytes = new byte[4];
                bytes[3] = (byte)value;
                bytes[2] = (byte)(value >> 8);
                bytes[1] = (byte)(value >> 16);
                bytes[0] = (byte)(value >> 24);
            }
        } else if (value == Integer.MIN_VALUE) {
            bytes = new byte[4];
            bytes[3] = (byte)value;
            bytes[2] = (byte)(value >> 8);
            bytes[1] = (byte)(value >> 16);
            bytes[0] = (byte)(value >> 24);
        } else if (value >= -128) {
            bytes = new byte[]{(byte)value};
        } else if (value >= Short.MIN_VALUE) {
            bytes = new byte[2];
            bytes[1] = (byte)(value & 0xFF);
            bytes[0] = (byte)(value >> 8);
        } else if (value >= -8388608) {
            bytes = new byte[3];
            bytes[2] = (byte)value;
            bytes[1] = (byte)(value >> 8);
            bytes[0] = (byte)(value >> 16);
        } else {
            bytes = new byte[4];
            bytes[3] = (byte)value;
            bytes[2] = (byte)(value >> 8);
            bytes[1] = (byte)(value >> 16);
            bytes[0] = (byte)(value >> 24);
        }
        return bytes;
    }

    public static void encode(ByteBuffer buffer, String string) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)4);
            byte[] value = Asn1StringUtils.getBytesUtf8(string);
            buffer.put(TLV.getBytes(value.length));
            if (value.length != 0) {
                buffer.put(value);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public static void encode(ByteBuffer buffer, BitString bitString) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)3);
            int length = bitString.size() + 1;
            buffer.put(TLV.getBytes(length));
            buffer.put(bitString.getUnusedBits());
            buffer.put(bitString.getData());
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public static void encode(ByteBuffer buffer, byte[] bytes) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)4);
            if (bytes == null || bytes.length == 0) {
                buffer.put((byte)0);
            } else {
                buffer.put(TLV.getBytes(bytes.length));
                buffer.put(bytes);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public static void encode(ByteBuffer buffer, OID oid) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)4);
            buffer.put(TLV.getBytes(oid.getOIDLength()));
            if (oid.getOIDLength() != 0) {
                buffer.put(oid.getOID());
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public static void encode(ByteBuffer buffer, int value) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)2);
            buffer.put((byte)Value.getNbBytes(value));
            buffer.put(Value.getBytes(value));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public static void encode(ByteBuffer buffer, byte tag, int value) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put(tag);
            buffer.put((byte)Value.getNbBytes(value));
            buffer.put(Value.getBytes(value));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public static void encodeEnumerated(ByteBuffer buffer, int value) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)10);
            buffer.put(TLV.getBytes(Value.getNbBytes(value)));
            buffer.put(Value.getBytes(value));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public static void encode(ByteBuffer buffer, boolean bool) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put(bool ? ENCODED_TRUE : ENCODED_FALSE);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DATA");
        if (this.data == null) {
            return "[]";
        }
        sb.append('[');
        sb.append(Asn1StringUtils.dumpBytes(this.data));
        sb.append(']');
        return sb.toString();
    }
}

