/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.grammar;

import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.grammar.IStates;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Tag;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)AbstractGrammar.class);
    protected GrammarTransition[][] transitions;
    protected String name;
    protected IStates statesEnum;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void checkLength(Asn1Object object, TLV tlv) throws DecoderException {
        int expectedLength = tlv.getLength().getLength();
        int tlvLength = tlv.getSize();
        if (log.isDebugEnabled()) {
            log.debug("Expected Length = " + object.getExpectedLength() + ", current length = " + object.getCurrentLength() + ", added length = " + expectedLength + ", tlv length = " + tlvLength);
        }
        object.addLength(tlvLength);
    }

    public GrammarTransition getTransition(int state, int tag) {
        return this.transitions[state][tag & 0xFF];
    }

    public void executeAction(IAsn1Container container) throws DecoderException {
        block9: {
            int nextState;
            GrammarTransition transition;
            int currentState = container.getTransition();
            IGrammar currentGrammar = container.getGrammar();
            if (currentState == -1 && (currentState = container.restoreGrammar()) == -1) {
                return;
            }
            Tag tag = container.getCurrentTLV().getTag();
            byte tagByte = tag.getTagByte();
            while (true) {
                if ((transition = ((AbstractGrammar)container.getGrammar()).getTransition(currentState, tagByte & 0xFF)) == null) {
                    if (container.getCurrentGrammar() == 0) {
                        String errorMessage = "Bad transition from state " + currentGrammar.getStatesEnum().getState(container.getCurrentGrammarType(), currentState) + ", tag " + Asn1StringUtils.dumpByte(tag.getTagByte());
                        log.error(errorMessage);
                        throw new DecoderException("Bad transition !");
                    }
                    if (container.isGrammarPopAllowed()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Pop grammar {}, state = {}", (Object)container.getStates().getGrammarName(currentGrammar), (Object)currentGrammar.getStatesEnum().getState(container.getCurrentGrammarType(), currentState));
                        }
                        currentState = container.restoreGrammar();
                        continue;
                    }
                    String msg = "Cannot pop the grammar " + container.getStates().getGrammarName(currentGrammar) + " for state " + currentGrammar.getStatesEnum().getState(container.getCurrentGrammarType(), currentState);
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                if (log.isDebugEnabled()) {
                    log.debug(transition.toString(container.getCurrentGrammarType(), currentGrammar.getStatesEnum()));
                }
                if (((nextState = transition.getNextState()) & 0xFF00) == 0 || nextState == -1) break;
                if (transition.hasAction()) {
                    transition.getAction().action(container);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Switching from grammar {} to grammar {}", (Object)container.getStates().getGrammarName(currentGrammar), (Object)container.getStates().getGrammarName((nextState >> 8) - 1));
                }
                container.switchGrammar(currentState, nextState & 0xFF00);
                currentState = 0;
            }
            container.setTransition(nextState);
            if (!transition.hasAction()) break block9;
            transition.getAction().action(container);
        }
    }

    public IStates getStatesEnum() {
        return this.statesEnum;
    }

    public void setStatesEnum(IStates statesEnum) {
        this.statesEnum = statesEnum;
    }
}

