/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.primitives;

import java.io.Serializable;
import org.apache.directory.shared.asn1.codec.DecoderException;

public class OID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long[] oidValues;

    public OID() {
    }

    public OID(byte[] oid) throws DecoderException {
        this.setOID(oid);
    }

    public OID(String oid) throws DecoderException {
        this.setOID(oid);
    }

    public void setOID(byte[] oid) throws DecoderException {
        if (oid == null) {
            throw new DecoderException("Null OID");
        }
        if (oid.length < 1) {
            throw new DecoderException("Invalid OID : " + oid);
        }
        int nbValues = 1;
        int pos = 0;
        while (pos < oid.length) {
            if (oid[pos] >= 0) {
                ++nbValues;
            }
            ++pos;
        }
        this.oidValues = new long[nbValues];
        nbValues = 0;
        pos = 0;
        int accumulator = 0;
        if (oid[0] < 0 || oid[0] >= 80) {
            this.oidValues[nbValues++] = 2L;
            while (pos < oid.length) {
                if (oid[pos] >= 0) {
                    this.oidValues[nbValues++] = (accumulator << 7) + oid[pos] - 80;
                    accumulator = 0;
                    ++pos;
                    break;
                }
                accumulator = (accumulator << 7) + (oid[pos] & 0x7F);
                ++pos;
            }
        } else if (oid[0] < 40) {
            this.oidValues[nbValues++] = 0L;
            this.oidValues[nbValues++] = oid[pos++];
        } else {
            this.oidValues[nbValues++] = 1L;
            this.oidValues[nbValues++] = oid[pos++] - 40;
        }
        while (pos < oid.length) {
            if (oid[pos] >= 0) {
                this.oidValues[nbValues++] = (accumulator << 7) + oid[pos];
                accumulator = 0;
            } else {
                accumulator = (accumulator << 7) + (oid[pos] & 0x7F);
            }
            ++pos;
        }
    }

    public void setOID(String oid) throws DecoderException {
        if (oid == null || oid.length() == 0) {
            throw new DecoderException("Null OID");
        }
        int nbValues = 1;
        char[] bytes = oid.toCharArray();
        boolean dotSeen = false;
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == '.') {
                if (dotSeen) {
                    throw new DecoderException("Invalid OID : " + oid);
                }
                ++nbValues;
                dotSeen = true;
            } else {
                dotSeen = false;
            }
            ++i;
        }
        if (nbValues < 2) {
            throw new DecoderException("Invalid OID : " + oid);
        }
        this.oidValues = new long[nbValues];
        int pos = 0;
        int intPos = 0;
        boolean ituOrIso = false;
        switch (bytes[pos]) {
            case '0': 
            case '1': {
                ituOrIso = true;
            }
            case '2': {
                this.oidValues[intPos++] = bytes[pos++] - 48;
                break;
            }
            default: {
                throw new DecoderException("Invalid OID : " + oid);
            }
        }
        if (bytes[pos++] != '.') {
            throw new DecoderException("Invalid OID : " + oid);
        }
        dotSeen = true;
        int value = 0;
        int i2 = pos;
        while (i2 < bytes.length) {
            if (bytes[i2] == '.') {
                if (dotSeen) {
                    throw new DecoderException("Invalid OID : " + oid);
                }
                if (ituOrIso && value > 39) {
                    throw new DecoderException("Invalid OID : " + oid);
                }
                ituOrIso = false;
                ++nbValues;
                dotSeen = true;
                this.oidValues[intPos++] = value;
                value = 0;
            } else if (bytes[i2] >= '0' && bytes[i2] <= '9') {
                dotSeen = false;
                value = value * 10 + bytes[i2] - 48;
            } else {
                throw new DecoderException("Invalid OID : " + oid);
            }
            ++i2;
        }
        this.oidValues[intPos++] = value;
    }

    public long[] getOIDValues() {
        return this.oidValues;
    }

    public int getOIDLength() {
        long value = this.oidValues[0] * 40L + this.oidValues[1];
        int nbBytes = 0;
        nbBytes = value < 128L ? 1 : (value < 16384L ? 2 : (value < 0x200000L ? 3 : (value < 0x10000000L ? 4 : 5)));
        int i = 2;
        while (i < this.oidValues.length) {
            value = this.oidValues[i];
            nbBytes = value < 128L ? ++nbBytes : (value < 16384L ? (nbBytes += 2) : (value < 0x200000L ? (nbBytes += 3) : (value < 0x10000000L ? (nbBytes += 4) : (nbBytes += 5))));
            ++i;
        }
        return nbBytes;
    }

    public byte[] getOID() {
        long value;
        long firstValues = value = this.oidValues[0] * 40L + this.oidValues[1];
        byte[] bytes = new byte[this.getOIDLength()];
        int pos = 0;
        if (this.oidValues[0] < 2L) {
            bytes[pos++] = (byte)(this.oidValues[0] * 40L + this.oidValues[1]);
        } else if (firstValues < 128L) {
            bytes[pos++] = (byte)firstValues;
        } else if (firstValues < 16384L) {
            bytes[pos++] = (byte)(firstValues >> 7 | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        } else if (value < 0x200000L) {
            bytes[pos++] = (byte)(firstValues >> 14 | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        } else if (value < 0x10000000L) {
            bytes[pos++] = (byte)(firstValues >> 21 | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 14 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        } else {
            bytes[pos++] = (byte)(firstValues >> 28 | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 21 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 14 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues >> 7 & 0x7FL | 0x80L);
            bytes[pos++] = (byte)(firstValues & 0x7FL);
        }
        int i = 2;
        while (i < this.oidValues.length) {
            value = this.oidValues[i];
            if (value < 128L) {
                bytes[pos++] = (byte)value;
            } else if (value < 16384L) {
                bytes[pos++] = (byte)(value >> 7 | 0x80L);
                bytes[pos++] = (byte)(value & 0x7FL);
            } else if (value < 0x200000L) {
                bytes[pos++] = (byte)(value >> 14 | 0x80L);
                bytes[pos++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value & 0x7FL);
            } else if (value < 0x10000000L) {
                bytes[pos++] = (byte)(value >> 21 | 0x80L);
                bytes[pos++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value & 0x7FL);
            } else {
                bytes[pos++] = (byte)(value >> 28 | 0x80L);
                bytes[pos++] = (byte)(value >> 21 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value >> 14 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value >> 7 & 0x7FL | 0x80L);
                bytes[pos++] = (byte)(value & 0x7FL);
            }
            ++i;
        }
        return bytes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.oidValues != null) {
            sb.append(this.oidValues[0]);
            int i = 1;
            while (i < this.oidValues.length) {
                sb.append('.').append(this.oidValues[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public static boolean isOID(String oid) {
        if (oid == null || oid.length() == 0) {
            return false;
        }
        int nbValues = 1;
        byte[] bytes = oid.getBytes();
        boolean dotSeen = false;
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 46) {
                if (dotSeen) {
                    return false;
                }
                ++nbValues;
                dotSeen = true;
            } else {
                dotSeen = false;
            }
            ++i;
        }
        if (nbValues < 2) {
            return false;
        }
        int pos = 0;
        boolean ituOrIso = false;
        switch (bytes[pos++]) {
            case 48: 
            case 49: {
                ituOrIso = true;
            }
            case 50: {
                break;
            }
            default: {
                return false;
            }
        }
        if (bytes[pos++] != 46) {
            return false;
        }
        dotSeen = true;
        long value = 0L;
        int i2 = pos;
        while (i2 < bytes.length) {
            if (bytes[i2] == 46) {
                if (dotSeen) {
                    return false;
                }
                if (ituOrIso && value > 39L) {
                    return false;
                }
                ituOrIso = false;
                ++nbValues;
                dotSeen = true;
                value = 0L;
            } else if (bytes[i2] >= 48 && bytes[i2] <= 57) {
                dotSeen = false;
                value = value * 10L + (long)bytes[i2] - 48L;
            } else {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

