/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;

public abstract class Asn1Object {
    private transient int currentLength;
    private transient int expectedLength;
    protected transient Asn1Object parent;
    private transient int tlvId;

    protected Asn1Object(int tlvId) {
        this.tlvId = tlvId;
    }

    protected Asn1Object() {
        this.tlvId = -1;
    }

    public int getCurrentLength() {
        return this.currentLength;
    }

    public abstract int computeLength();

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        return null;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public void addLength(int length) throws DecoderException {
        this.currentLength += length;
        if (this.currentLength > this.expectedLength) {
            throw new DecoderException("Current Length is above expected Length");
        }
    }

    public void setExpectedLength(int expectedLength) {
        this.expectedLength = expectedLength;
    }

    public void setCurrentLength(int currentLength) {
        this.currentLength = currentLength;
    }

    public Asn1Object getParent() {
        return this.parent;
    }

    public void setParent(Asn1Object parent) {
        this.parent = parent;
    }

    public int getTlvId() {
        return this.tlvId;
    }
}

