/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.primitives;

import java.io.Serializable;
import org.apache.directory.shared.i18n.I18n;

public class BitString
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BitString EMPTY_STRING = new BitString(1);
    public static final boolean STREAMED = true;
    private static final int DEFAULT_LENGTH = 1024;
    private int nbUnusedBits;
    private boolean isStreamed;
    private byte[] bytes;
    private int nbBytes;
    private int nbBits;

    public BitString(int length) {
        if (length <= 0) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00029_NULL_OR_NEG_LENGTH_NOT_ALLOWED, (Object[])new Object[0]));
        }
        this.nbBits = length;
        this.nbBytes = length / 8;
        if (length % 8 != 0) {
            ++this.nbBytes;
        }
        this.nbUnusedBits = (8 - length % 8) % 8;
        if (this.nbBytes > 1024) {
            this.isStreamed = true;
            this.bytes = new byte[this.nbBytes];
        } else {
            this.isStreamed = false;
            this.bytes = new byte[this.nbBytes];
        }
    }

    public BitString(int length, boolean isStreamed) {
        if (length <= 0) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00029_NULL_OR_NEG_LENGTH_NOT_ALLOWED, (Object[])new Object[0]));
        }
        this.nbBits = length;
        this.isStreamed = isStreamed;
        this.nbBytes = length / 8;
        if (length % 8 != 0) {
            ++this.nbBytes;
        }
        this.nbUnusedBits = length % 8;
        this.bytes = new byte[this.nbBytes];
    }

    public BitString(byte[] bytes) {
        this.nbBytes = bytes.length - 1;
        if (this.nbBytes > 1024) {
            this.isStreamed = true;
            this.bytes = new byte[this.nbBytes];
        } else {
            this.isStreamed = false;
            this.bytes = new byte[this.nbBytes];
        }
        this.setBytes(bytes, this.nbBytes);
    }

    private void setBytes(byte[] bytes, int nbBytes) {
        this.nbUnusedBits = bytes[0] & 7;
        this.nbBits = nbBytes * 8 - this.nbUnusedBits;
        for (int i = 0; i < nbBytes; ++i) {
            this.bytes[i] = bytes[i + 1];
        }
    }

    public void setData(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.nbBits = -1;
            return;
        }
        int nbb = bytes.length - 1;
        if (nbb > 1024 && bytes.length < nbb) {
            bytes = new byte[nbb];
        }
        this.setBytes(bytes, nbb);
    }

    public byte[] getData() {
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return copy;
    }

    public byte[] getDataRef() {
        return this.bytes;
    }

    public byte getUnusedBits() {
        return (byte)this.nbUnusedBits;
    }

    public void setBit(int pos) {
        if (pos < 0 || pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00030_BIT_NUMBER_OUT_OF_BOUND, (Object[])new Object[0]));
        }
        int posInt = this.nbBytes - 1 - (pos + this.nbUnusedBits >> 3);
        int bitNumber = (pos + this.nbUnusedBits) % 8;
        int n = posInt;
        this.bytes[n] = (byte)(this.bytes[n] | 1 << bitNumber);
    }

    public void clearBit(int pos) {
        if (pos < 0 || pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00030_BIT_NUMBER_OUT_OF_BOUND, (Object[])new Object[0]));
        }
        int posInt = this.nbBytes - 1 - (pos + this.nbUnusedBits >> 3);
        int bitNumber = (pos + this.nbUnusedBits) % 8;
        int n = posInt;
        this.bytes[n] = (byte)(this.bytes[n] & ~(1 << bitNumber));
    }

    public boolean getBit(int pos) {
        if (pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_00031_CANNOT_FIND_BIT, (Object[])new Object[]{pos, this.nbBits}));
        }
        int posInt = this.nbBytes - 1 - (pos + this.nbUnusedBits >> 3);
        int bitNumber = (pos + this.nbUnusedBits) % 8;
        int res = this.bytes[posInt] & 1 << bitNumber;
        return res != 0;
    }

    public int size() {
        return this.nbBytes;
    }

    public boolean isStreamed() {
        return this.isStreamed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.nbBits; i > 0; --i) {
            if (this.getBit(i)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }
}

