/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BERConstructedOctetString
extends DEROctetString {
    private Vector<DEREncodable> octets;

    public BERConstructedOctetString(byte[] string) {
        super(string);
    }

    public BERConstructedOctetString(Vector<DEREncodable> octets) {
        super(BERConstructedOctetString.toBytes(octets));
        this.octets = octets;
    }

    private static byte[] toBytes(Vector<DEREncodable> octs) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i != octs.size(); ++i) {
            try {
                DEROctetString o = (DEROctetString)octs.elementAt(i);
                baos.write(o.getOctets());
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_00025_DER_OCTET_STRING_EXPECTED, (Object[])new Object[]{octs.elementAt(i).getClass().getName()}));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_00026_CANNOT_CONVERT_OCTETS, (Object[])new Object[]{e.toString()}));
            }
        }
        return baos.toByteArray();
    }

    public Enumeration<DEREncodable> getObjects() {
        if (this.octets == null) {
            return this.generateOcts().elements();
        }
        return this.octets.elements();
    }

    private Vector<DEREncodable> generateOcts() {
        byte[] nStr;
        int start = 0;
        int end = 0;
        Vector<DEREncodable> vector = new Vector<DEREncodable>();
        while (end + 1 < this.value.length) {
            if (this.value[end] == 0 && this.value[end + 1] == 0) {
                nStr = new byte[end - start + 1];
                System.arraycopy(this.value, start, nStr, 0, nStr.length);
                vector.addElement(new DEROctetString(nStr));
                start = end + 1;
            }
            ++end;
        }
        nStr = new byte[this.value.length - start];
        System.arraycopy(this.value, start, nStr, 0, nStr.length);
        vector.addElement(new DEROctetString(nStr));
        return vector;
    }

    @Override
    public void encode(ASN1OutputStream out) throws IOException {
        out.write(36);
        out.write(128);
        if (this.octets != null) {
            for (int i = 0; i != this.octets.size(); ++i) {
                out.writeObject(this.octets.elementAt(i));
            }
        } else {
            byte[] newString;
            int start = 0;
            int end = 0;
            while (end + 1 < this.value.length) {
                if (this.value[end] == 0 && this.value[end + 1] == 0) {
                    newString = new byte[end - start + 1];
                    System.arraycopy(this.value, start, newString, 0, newString.length);
                    out.writeObject(new DEROctetString(newString));
                    start = end + 1;
                }
                ++end;
            }
            newString = new byte[this.value.length - start];
            System.arraycopy(this.value, start, newString, 0, newString.length);
            out.writeObject(new DEROctetString(newString));
        }
        out.write(0);
        out.write(0);
    }
}

