/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.grammar;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.States;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrammar<E extends Asn1Container>
implements Grammar<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGrammar.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    protected GrammarTransition<E>[][] transitions;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public GrammarTransition<E> getTransition(Enum<?> state, int tag) {
        return this.transitions[state.ordinal()][tag & 0xFF];
    }

    @Override
    public void executeAction(E container) throws DecoderException {
        Enum<?> currentState = container.getTransition();
        if (((States)((Object)currentState)).isEndState()) {
            return;
        }
        byte tagByte = container.getCurrentTLV().getTag();
        GrammarTransition<E> transition = ((AbstractGrammar)container.getGrammar()).getTransition(currentState, tagByte);
        if (transition == null) {
            String errorMessage = I18n.err((I18n)I18n.ERR_00001_BAD_TRANSITION_FROM_STATE, (Object[])new Object[]{currentState, Asn1StringUtils.dumpByte((byte)tagByte)});
            LOG.error(errorMessage);
            throw new DecoderException(errorMessage);
        }
        if (IS_DEBUG) {
            LOG.debug(transition.toString());
        }
        if (transition.hasAction()) {
            Action<E> action = transition.getAction();
            action.action(container);
        }
        container.setTransition(transition.getCurrentState());
    }
}

