/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.util.Strings;

public abstract class LoadableSchemaObject
extends AbstractSchemaObject {
    private static final long serialVersionUID = 2L;
    private String fqcn = "";
    private String bytecode = null;

    protected LoadableSchemaObject(SchemaObjectType objectType, String oid) {
        super(objectType, oid);
    }

    protected LoadableSchemaObject(SchemaObjectType objectType) {
        super(objectType);
    }

    public String getBytecode() {
        return this.bytecode;
    }

    public void setBytecode(String bytecode) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.bytecode = bytecode;
        }
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public void setFqcn(String fqcn) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_04441, this.getName()));
        }
        if (!this.isReadOnly) {
            this.fqcn = fqcn;
        }
    }

    public LoadableSchemaObject copy() {
        return null;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LoadableSchemaObject)) {
            return false;
        }
        LoadableSchemaObject that = (LoadableSchemaObject)o;
        if (this.fqcn == null) {
            return that.fqcn == null;
        }
        return this.fqcn.equals(that.fqcn);
    }

    public boolean isValid() {
        String className = this.getClass().getName();
        if (Strings.isEmpty(this.fqcn)) {
            this.fqcn = className;
            return true;
        }
        return className.equals(this.fqcn);
    }
}

