/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.converter.schema;

import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import org.apache.directory.shared.converter.schema.ParserException;
import org.apache.directory.shared.converter.schema.Schema;
import org.apache.directory.shared.converter.schema.SchemaElement;
import org.apache.directory.shared.converter.schema.SchemaParser;
import org.apache.directory.shared.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaToLdif {
    private static final String HEADER = "#\n#  Licensed to the Apache Software Foundation (ASF) under one\n#  or more contributor license agreements.  See the NOTICE file\n#  distributed with this work for additional information\n#  regarding copyright ownership.  The ASF licenses this file\n#  to you under the Apache License, Version 2.0 (the\n#  \"License\"); you may not use this file except in compliance\n#  with the License.  You may obtain a copy of the License at\n#  \n#    http://www.apache.org/licenses/LICENSE-2.0\n#  \n#  Unless required by applicable law or agreed to in writing,\n#  software distributed under the License is distributed on an\n#  \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n#  KIND, either express or implied.  See the License for the\n#  specific language governing permissions and limitations\n#  under the License. \n#\nversion: 1\n\n";
    private static final Logger LOG = LoggerFactory.getLogger(SchemaToLdif.class);

    private SchemaToLdif() {
    }

    public static void transform(List<Schema> schemas) throws ParserException {
        if (schemas == null || schemas.size() == 0) {
            LOG.warn("No schemas defined!");
            return;
        }
        int i = 1;
        for (Schema schema : schemas) {
            if (schema.getName() != null) continue;
            String msg = I18n.err(I18n.ERR_06003_NO_NAME, i);
            LOG.error(msg);
            throw new ParserException(msg);
        }
        for (Schema schema : schemas) {
            try {
                LOG.info("Generating {} schema.", (Object)schema.getName());
                SchemaToLdif.generate(schema);
            }
            catch (Exception e) {
                throw new ParserException(I18n.err(I18n.ERR_06004_CANNOT_GENERATE_SOURCES, schema.getName()));
            }
        }
    }

    private static void generate(Schema schema) throws Exception {
        if (schema == null) {
            LOG.error(I18n.err(I18n.ERR_06005_NULL_SCHEMA, new Object[0]));
            throw new IllegalArgumentException(I18n.err(I18n.ERR_06006_NO_PROPERTY, new Object[0]));
        }
        InputStream in = schema.getInput();
        Writer out = schema.getOutput();
        SchemaParser parser = new SchemaParser();
        List<SchemaElement> elements = parser.parse(in);
        out.write(HEADER);
        for (SchemaElement element : elements) {
            out.write(element.toLdif(schema.getName()));
            out.write(10);
        }
        out.flush();
        out.close();
        in.close();
    }
}

