/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.store.derby;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.DefaultCSN;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.operation.OperationCodec;
import org.apache.directory.mitosis.store.ReplicationLogIterator;
import org.apache.directory.mitosis.store.ReplicationStoreException;
import org.apache.directory.mitosis.store.derby.SQLUtil;
import org.apache.directory.server.schema.registries.Registries;

class DerbyReplicationLogIterator
implements ReplicationLogIterator {
    private final OperationCodec codec;
    private final Connection con;
    private final Statement stmt;
    private final ResultSet rs;

    DerbyReplicationLogIterator(OperationCodec codec, Connection con, Statement stmt, ResultSet rs) {
        this.codec = codec;
        this.con = con;
        this.stmt = stmt;
        this.rs = rs;
    }

    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new ReplicationStoreException(e);
        }
    }

    public void close() {
        SQLUtil.cleanup(this.con, this.stmt, this.rs);
    }

    public CSN getCSN() {
        try {
            String replicaId = this.rs.getString(1);
            long timestamp = this.rs.getLong(2);
            int operationSequence = this.rs.getInt(3);
            return new DefaultCSN(timestamp, replicaId, operationSequence);
        }
        catch (Exception e) {
            throw new ReplicationStoreException(e);
        }
    }

    public Operation getOperation(Registries registries) {
        try {
            return this.codec.decode(registries, this.rs.getBytes(4));
        }
        catch (Exception e) {
            throw new ReplicationStoreException(e);
        }
    }
}

