/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service.protocol.handler;

import java.net.InetSocketAddress;
import org.apache.directory.mitosis.common.CSNVector;
import org.apache.directory.mitosis.common.Replica;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.service.ReplicationContext;
import org.apache.directory.mitosis.service.protocol.handler.ReplicationContextHandler;
import org.apache.directory.mitosis.service.protocol.message.BeginLogEntriesAckMessage;
import org.apache.directory.mitosis.service.protocol.message.BeginLogEntriesMessage;
import org.apache.directory.mitosis.service.protocol.message.EndLogEntriesAckMessage;
import org.apache.directory.mitosis.service.protocol.message.EndLogEntriesMessage;
import org.apache.directory.mitosis.service.protocol.message.LogEntryAckMessage;
import org.apache.directory.mitosis.service.protocol.message.LogEntryMessage;
import org.apache.directory.mitosis.service.protocol.message.LoginAckMessage;
import org.apache.directory.mitosis.service.protocol.message.LoginMessage;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;

public class ReplicationServerContextHandler
implements ReplicationContextHandler {
    private Replica replicaInTransaction;

    public void contextBegin(ReplicationContext ctx) throws Exception {
        ctx.getSession().setIdleTime(IdleStatus.BOTH_IDLE, ctx.getConfiguration().getResponseTimeout());
        ctx.getSession().setWriteTimeout(ctx.getConfiguration().getResponseTimeout());
    }

    public synchronized void contextEnd(ReplicationContext ctx) throws Exception {
        if (ctx.getPeer() != null && ctx.getPeer().equals(this.replicaInTransaction)) {
            this.replicaInTransaction = null;
        }
    }

    public void messageReceived(ReplicationContext ctx, Object message) throws Exception {
        if (ctx.getState() == ReplicationContext.State.READY) {
            if (message instanceof LogEntryMessage) {
                this.onLogEntry(ctx, (LogEntryMessage)message);
            } else if (message instanceof BeginLogEntriesMessage) {
                this.onBeginLogEntries(ctx, (BeginLogEntriesMessage)message);
            } else if (message instanceof EndLogEntriesMessage) {
                this.onEndLogEntries(ctx, (EndLogEntriesMessage)message);
            } else {
                this.onUnexpectedMessage(ctx, message);
            }
        } else if (message instanceof LoginMessage) {
            this.onLogin(ctx, (LoginMessage)message);
        } else {
            this.onUnexpectedMessage(ctx, message);
        }
    }

    public void messageSent(ReplicationContext ctx, Object message) throws Exception {
    }

    public void exceptionCaught(ReplicationContext ctx, Throwable cause) throws Exception {
        SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Unexpected exception."), (Throwable)cause);
        ctx.getSession().close();
    }

    public void contextIdle(ReplicationContext ctx, IdleStatus status) throws Exception {
        if (ctx.getState() == ReplicationContext.State.INIT) {
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] No login attempt in " + ctx.getConfiguration().getResponseTimeout() + " second(s)."));
            ctx.getSession().close();
        }
    }

    private void onLogin(ReplicationContext ctx, LoginMessage message) {
        for (Replica replica : ctx.getConfiguration().getPeerReplicas()) {
            if (!replica.getId().equals(message.getReplicaId())) continue;
            if (replica.getAddress().getAddress().equals(((InetSocketAddress)ctx.getSession().getRemoteAddress()).getAddress())) {
                ctx.getSession().write((Object)new LoginAckMessage(message.getSequence(), 0, ctx.getConfiguration().getReplicaId()));
                ctx.setPeer(replica);
                ctx.setState(ReplicationContext.State.READY);
                ctx.getSession().setIdleTime(IdleStatus.BOTH_IDLE, 0);
                return;
            }
            SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Peer address mismatches: " + ctx.getSession().getRemoteAddress() + " (expected: " + replica.getAddress()));
            ctx.getSession().write((Object)new LoginAckMessage(message.getSequence(), -1, ctx.getConfiguration().getReplicaId()));
            ctx.getSession().close();
            return;
        }
        SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Unknown peer replica ID: " + message.getReplicaId()));
        ctx.getSession().write((Object)new LoginAckMessage(message.getSequence(), -1, ctx.getConfiguration().getReplicaId()));
        ctx.getSession().close();
    }

    private synchronized void onLogEntry(ReplicationContext ctx, LogEntryMessage message) throws Exception {
        if (!ctx.getPeer().equals(this.replicaInTransaction)) {
            ctx.getSession().write((Object)new LogEntryAckMessage(message.getSequence(), -1));
            return;
        }
        Operation op = message.getOperation();
        LogEntryAckMessage ack = null;
        try {
            op.execute(ctx.getDirectoryService().getPartitionNexus(), ctx.getConfiguration().getStore(), ctx.getDirectoryService().getSession());
            ack = new LogEntryAckMessage(message.getSequence(), 0);
        }
        catch (Exception e) {
            try {
                ack = new LogEntryAckMessage(message.getSequence(), -1);
                throw e;
            }
            catch (Throwable throwable) {
                ctx.getSession().write(ack);
                throw throwable;
            }
        }
        ctx.getSession().write((Object)ack);
    }

    private synchronized void onBeginLogEntries(ReplicationContext ctx, BeginLogEntriesMessage message) {
        if (this.replicaInTransaction != null) {
            ctx.getSession().write((Object)new BeginLogEntriesAckMessage(message.getSequence(), -1, null, null));
            return;
        }
        ReplicationStore store = ctx.getConfiguration().getStore();
        try {
            CSNVector pv = store.getPurgeVector();
            CSNVector uv = store.getUpdateVector();
            this.replicaInTransaction = ctx.getPeer();
            ctx.getSession().write((Object)new BeginLogEntriesAckMessage(message.getSequence(), 0, pv, uv));
        }
        catch (Exception e) {
            SessionLog.warn((IoSession)ctx.getSession(), (String)"Failed to get update vector.", (Throwable)e);
            ctx.getSession().write((Object)new BeginLogEntriesAckMessage(message.getSequence(), -1, null, null));
        }
    }

    private synchronized void onEndLogEntries(ReplicationContext ctx, EndLogEntriesMessage message) {
        if (!ctx.getPeer().equals(this.replicaInTransaction)) {
            ctx.getSession().write((Object)new EndLogEntriesAckMessage(message.getSequence(), -1));
            return;
        }
        ctx.getSession().write((Object)new EndLogEntriesAckMessage(message.getSequence(), 0));
        this.replicaInTransaction = null;
    }

    private void onUnexpectedMessage(ReplicationContext ctx, Object message) {
        SessionLog.warn((IoSession)ctx.getSession(), (String)("[Replica-" + ctx.getConfiguration().getReplicaId() + "] Unexpected message: " + message));
        ctx.getSession().close();
    }
}

