/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service.protocol.codec;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.directory.mitosis.common.CSNVector;
import org.apache.directory.mitosis.common.DefaultCSN;
import org.apache.directory.mitosis.service.protocol.codec.ResponseMessageDecoder;
import org.apache.directory.mitosis.service.protocol.message.BaseMessage;
import org.apache.directory.mitosis.service.protocol.message.BeginLogEntriesAckMessage;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class BeginLogEntriesAckMessageDecoder
extends ResponseMessageDecoder {
    private final CharsetDecoder utf8decoder = Charset.forName("UTF-8").newDecoder();

    public BeginLogEntriesAckMessageDecoder() {
        super(3, 0, 3072);
    }

    protected BaseMessage decodeBody(Registries registries, int sequence, int bodyLength, int responseCode, ByteBuffer in) throws Exception {
        if (responseCode != 0) {
            return new BeginLogEntriesAckMessage(sequence, responseCode, null, null);
        }
        CSNVector purgeVector = new CSNVector();
        CSNVector updateVector = new CSNVector();
        BeginLogEntriesAckMessage m = new BeginLogEntriesAckMessage(sequence, responseCode, purgeVector, updateVector);
        this.readCSNVector(in, purgeVector);
        this.readCSNVector(in, updateVector);
        return m;
    }

    private void readCSNVector(ByteBuffer in, CSNVector updateVector) throws Exception {
        int nReplicas = in.getInt();
        if (nReplicas < 0) {
            throw new ProtocolDecoderException("Wrong nReplicas: " + nReplicas);
        }
        while (nReplicas > 0) {
            String replicaId;
            try {
                replicaId = in.getString(this.utf8decoder);
            }
            catch (CharacterCodingException e) {
                throw new ProtocolDecoderException("Invalid replicaId", (Throwable)e);
            }
            updateVector.setCSN(new DefaultCSN(in.getLong(), replicaId, in.getInt()));
            --nReplicas;
        }
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

