/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.service;

import java.util.Map;
import org.apache.directory.mitosis.service.ReplicationInterceptor;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationLogCleanJob
implements Job {
    public static final String INSTANCE_ID = "instanceId";
    private Map<String, DirectoryService> services;

    public ReplicationLogCleanJob(Map<String, DirectoryService> services) {
        this.services = services;
    }

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        String instanceId = ctx.getJobDetail().getJobDataMap().getString(INSTANCE_ID);
        if (instanceId == null) {
            for (DirectoryService service : this.services.values()) {
                this.execute0(service);
            }
        } else {
            this.execute0(this.services.get(instanceId));
        }
    }

    private void execute0(DirectoryService service) throws JobExecutionException {
        for (Interceptor interceptor : service.getInterceptorChain().getAll()) {
            if (!(interceptor instanceof ReplicationInterceptor)) continue;
            try {
                ((ReplicationInterceptor)interceptor).purgeAgedData();
            }
            catch (Exception e) {
                throw new JobExecutionException((Throwable)e);
            }
        }
    }
}

