/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation.support;

import javax.naming.NameNotFoundException;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.DefaultCSN;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.StringTools;

public class EntryUtil {
    public static boolean isEntryUpdatable(CoreSession coreSession, LdapDN name, CSN newCSN) throws Exception {
        LookupOperationContext lookupContext;
        PartitionNexus nexus = coreSession.getDirectoryService().getPartitionNexus();
        ClonedServerEntry entry = nexus.lookup(lookupContext = new LookupOperationContext(coreSession, name));
        if (entry == null) {
            return true;
        }
        EntryAttribute entryCSNAttr = entry.get("entryCSN");
        if (entryCSNAttr == null) {
            return true;
        }
        DefaultCSN oldCSN = null;
        try {
            Value val = entryCSNAttr.get();
            oldCSN = val instanceof byte[] ? new DefaultCSN(StringTools.utf8ToString((byte[])((byte[])val))) : new DefaultCSN((String)val);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return oldCSN.compareTo(newCSN) < 0;
    }

    public static void createGlueEntries(CoreSession coreSession, LdapDN name, boolean includeLeaf) throws Exception {
        assert (name.size() > 0);
        for (int i = name.size() - 1; i > 0; --i) {
            EntryUtil.createGlueEntry(coreSession, (LdapDN)name.getSuffix(i));
        }
        if (includeLeaf) {
            EntryUtil.createGlueEntry(coreSession, name);
        }
    }

    private static void createGlueEntry(CoreSession coreSession, LdapDN name) throws Exception {
        DirectoryService ds = coreSession.getDirectoryService();
        PartitionNexus nexus = ds.getPartitionNexus();
        try {
            if (nexus.hasEntry(new EntryOperationContext(coreSession, name))) {
                return;
            }
        }
        catch (NameNotFoundException e) {
            return;
        }
        ServerEntry entry = ds.newEntry(name);
        String rdn = name.get(name.size() - 1);
        String rdnAttribute = NamespaceTools.getRdnAttribute((String)rdn);
        String rdnValue = NamespaceTools.getRdnValue((String)rdn);
        entry.put(rdnAttribute, new String[]{rdnValue});
        entry.put("objectClass", new String[]{"top", "extensibleObject"});
        nexus.add(new AddOperationContext(coreSession, entry));
    }

    private EntryUtil() {
    }
}

