/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.operation.AddAttributeOperation;
import org.apache.directory.mitosis.operation.AddEntryOperation;
import org.apache.directory.mitosis.operation.AttributeOperation;
import org.apache.directory.mitosis.operation.CompositeOperation;
import org.apache.directory.mitosis.operation.DeleteAttributeOperation;
import org.apache.directory.mitosis.operation.OperationType;
import org.apache.directory.mitosis.operation.ReplaceAttributeOperation;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.LdapDNSerializer;
import org.apache.directory.shared.ldap.schema.AttributeType;

public class Operation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected CSN csn;
    protected OperationType operationType;
    protected Registries registries;

    Operation(Registries registries, OperationType operationType) {
        this.registries = registries;
        this.operationType = operationType;
    }

    protected Operation(Registries registries, OperationType operationType, CSN csn) {
        assert (csn != null);
        this.registries = registries;
        this.csn = csn;
        this.operationType = operationType;
    }

    public CSN getCSN() {
        return this.csn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(PartitionNexus nexus, ReplicationStore store, CoreSession coreSession) throws Exception {
        PartitionNexus partitionNexus = nexus;
        synchronized (partitionNexus) {
            this.execute0(nexus, store, coreSession);
            store.putLog(this);
        }
    }

    protected void execute0(PartitionNexus nexus, ReplicationStore store, CoreSession coreSession) throws Exception {
        throw new OperationNotSupportedException(nexus.getSuffixDn().toString());
    }

    private static Operation readAttributeOperation(ObjectInput in, Registries registries, Operation operation) throws ClassNotFoundException, IOException {
        AttributeOperation attributeOperation = (AttributeOperation)operation;
        LdapDN dn = LdapDNSerializer.deserialize((ObjectInput)in);
        String id = in.readUTF();
        try {
            AttributeType at = registries.getAttributeTypeRegistry().lookup(id);
            DefaultServerAttribute attribute = new DefaultServerAttribute(id, at);
            attribute.deserialize(in);
            attributeOperation.dn = dn;
            attributeOperation.attribute = attribute;
            return operation;
        }
        catch (NamingException ne) {
            throw new IOException("Cannot find the '" + id + "' attributeType");
        }
    }

    public static Operation deserialize(Registries registries, ObjectInput in) throws ClassNotFoundException, IOException {
        int opTypeValue = in.readInt();
        OperationType opType = OperationType.get(opTypeValue);
        CSN csn = (CSN)in.readObject();
        Operation operation = null;
        switch (opType) {
            case ADD_ATTRIBUTE: {
                operation = new AddAttributeOperation(registries);
                operation.csn = csn;
                Operation.readAttributeOperation(in, registries, operation);
                return operation;
            }
            case DELETE_ATTRIBUTE: {
                operation = new DeleteAttributeOperation(registries);
                operation.csn = csn;
                Operation.readAttributeOperation(in, registries, operation);
                return operation;
            }
            case REPLACE_ATTRIBUTE: {
                operation = new ReplaceAttributeOperation(registries);
                operation.csn = csn;
                Operation.readAttributeOperation(in, registries, operation);
                return operation;
            }
            case ADD_ENTRY: {
                operation = new AddEntryOperation(registries);
                operation.csn = csn;
                DefaultServerEntry entry = new DefaultServerEntry(registries);
                entry.deserialize(in);
                ((AddEntryOperation)operation).setEntry((Entry)entry);
                return operation;
            }
            case COMPOSITE_OPERATION: {
                operation = new CompositeOperation(registries);
                operation.csn = csn;
                int nbOperations = in.readInt();
                for (int i = 0; i < nbOperations; ++i) {
                    Operation child = Operation.deserialize(registries, in);
                    child.csn = csn;
                    ((CompositeOperation)operation).add(child);
                }
                return operation;
            }
        }
        throw new IOException("Cannot read the unkown operation");
    }

    public static void serialize(Operation operation, ObjectOutput out) throws ClassNotFoundException, IOException {
        OperationType opType = operation.operationType;
        out.writeInt(opType.ordinal());
        out.writeObject(operation.csn);
        switch (opType) {
            case ADD_ATTRIBUTE: 
            case DELETE_ATTRIBUTE: 
            case REPLACE_ATTRIBUTE: {
                AttributeOperation attrOp = (AttributeOperation)operation;
                LdapDNSerializer.serialize((LdapDN)attrOp.dn, (ObjectOutput)out);
                out.writeUTF(((AttributeOperation)operation).attribute.getId());
                DefaultServerAttribute attr = (DefaultServerAttribute)attrOp.attribute;
                attr.serialize(out);
                return;
            }
            case ADD_ENTRY: {
                ((DefaultServerEntry)((AddEntryOperation)operation).getEntry()).serialize(out);
                return;
            }
            case COMPOSITE_OPERATION: {
                out.writeInt(((CompositeOperation)operation).size());
                for (Operation child : ((CompositeOperation)operation).getChildren()) {
                    Operation.serialize(child, out);
                }
                return;
            }
        }
    }

    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.csn = (CSN)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.csn);
    }

    public String toString() {
        return this.csn.toString();
    }
}

