/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation;

import java.util.List;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.operation.AttributeOperation;
import org.apache.directory.mitosis.operation.OperationType;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.name.LdapDN;

public class DeleteAttributeOperation
extends AttributeOperation {
    private static final long serialVersionUID = -131557844165710365L;

    DeleteAttributeOperation(Registries registries) {
        super(registries, OperationType.DELETE_ATTRIBUTE);
    }

    public DeleteAttributeOperation(Registries registries, CSN csn, LdapDN name, ServerAttribute attribute) {
        super(registries, OperationType.DELETE_ATTRIBUTE, csn, name, (EntryAttribute)attribute);
    }

    protected void execute1(PartitionNexus nexus, CoreSession coreSession) throws Exception {
        DirectoryService ds = coreSession.getDirectoryService();
        ServerEntry serverEntry = ds.newEntry(LdapDN.EMPTY_LDAPDN);
        EntryAttribute attribute = this.getAttribute();
        serverEntry.put(new EntryAttribute[]{attribute});
        List items = ModifyOperationContext.createModItems((ServerEntry)serverEntry, (ModificationOperation)ModificationOperation.REMOVE_ATTRIBUTE);
        nexus.modify(new ModifyOperationContext(coreSession, this.getDn(), items));
    }

    public String toString() {
        return super.toString() + ".delete( " + this.getAttribute() + " )";
    }
}

