/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.naming.Name;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.CSNVector;
import org.apache.directory.mitosis.configuration.ReplicationConfiguration;
import org.apache.directory.mitosis.operation.Operation;
import org.apache.directory.mitosis.operation.OperationType;
import org.apache.directory.mitosis.store.ReplicationLogIterator;
import org.apache.directory.mitosis.store.ReplicationStore;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.Registries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeOperation
extends Operation {
    private static final long serialVersionUID = 6252675003841951356L;
    private static final ReplicationStore DUMMY_STORE = new ReplicationStore(){

        @Override
        public void open(DirectoryService directoryService, ReplicationConfiguration cfg) {
        }

        @Override
        public void close() {
        }

        @Override
        public String getReplicaId() {
            return null;
        }

        @Override
        public Set<String> getKnownReplicaIds() {
            return null;
        }

        @Override
        public Name getDN(UUID uuid) {
            return null;
        }

        @Override
        public boolean putUUID(UUID uuid, Name dn) {
            return false;
        }

        @Override
        public boolean removeUUID(UUID uuid) {
            return false;
        }

        @Override
        public void putLog(Operation operation) {
        }

        @Override
        public ReplicationLogIterator getLogs(CSN fromCSN, boolean inclusive) {
            return null;
        }

        @Override
        public ReplicationLogIterator getLogs(CSNVector updateVector, boolean inclusive) {
            return null;
        }

        @Override
        public int removeLogs(CSN toCSN, boolean inclusive) {
            return 0;
        }

        @Override
        public int getLogSize() {
            return 0;
        }

        @Override
        public int getLogSize(String replicaId) {
            return 0;
        }

        @Override
        public CSNVector getUpdateVector() {
            return null;
        }

        @Override
        public CSNVector getPurgeVector() {
            return null;
        }
    };
    private final List<Operation> children = new ArrayList<Operation>();

    CompositeOperation(Registries registries) {
        super(registries, OperationType.COMPOSITE_OPERATION);
    }

    public CompositeOperation(Registries registries, CSN csn) {
        super(registries, OperationType.COMPOSITE_OPERATION, csn);
    }

    public void add(Operation op) {
        assert (op != null);
        assert (op.getCSN().equals(this.csn));
        this.children.add(op);
    }

    public void clear() {
        this.children.clear();
    }

    @Override
    protected void execute0(PartitionNexus nexus, ReplicationStore store, CoreSession coreSession) throws Exception {
        for (Operation op : this.children) {
            op.execute(nexus, DUMMY_STORE, coreSession);
        }
    }

    public int size() {
        return this.children.size();
    }

    public List<Operation> getChildren() {
        return this.children;
    }

    @Override
    public String toString() {
        return this.children.toString();
    }
}

