/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.operation;

import java.util.List;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.operation.AttributeOperation;
import org.apache.directory.mitosis.operation.OperationType;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.name.LdapDN;

public class AddAttributeOperation
extends AttributeOperation {
    private static final long serialVersionUID = 7373124294791982297L;

    AddAttributeOperation(Registries registries) {
        super(registries, OperationType.ADD_ATTRIBUTE);
    }

    public AddAttributeOperation(Registries registries, CSN csn, LdapDN name, EntryAttribute attribute) {
        super(registries, OperationType.ADD_ATTRIBUTE, csn, name, attribute);
    }

    protected void execute1(PartitionNexus nexus, CoreSession coreSession) throws Exception {
        DirectoryService ds = coreSession.getDirectoryService();
        ServerEntry serverEntry = ds.newEntry(LdapDN.EMPTY_LDAPDN);
        EntryAttribute attribute = this.getAttribute();
        serverEntry.put(new EntryAttribute[]{attribute});
        List items = ModifyOperationContext.createModItems((ServerEntry)serverEntry, (ModificationOperation)ModificationOperation.ADD_ATTRIBUTE);
        nexus.modify(new ModifyOperationContext(coreSession, this.getDn(), items));
    }

    public String toString() {
        return super.toString() + ".add( " + this.getAttribute() + " )";
    }
}

