/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mitosis.common;

import java.io.Serializable;
import org.apache.directory.mitosis.common.CSN;
import org.apache.directory.mitosis.common.InvalidCSNException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCSN
implements CSN,
Serializable,
Comparable<CSN> {
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private final String replicaId;
    private final int operationSequence;
    private transient String csnStr;
    private transient byte[] bytes;

    public DefaultCSN(long timestamp, String replicaId, int operationSequence) {
        this.timestamp = timestamp;
        this.replicaId = replicaId;
        this.operationSequence = operationSequence;
    }

    public DefaultCSN(String value) throws InvalidCSNException {
        assert (value != null);
        int sepTS = value.indexOf(58);
        assert (sepTS > 0);
        int sepID = value.lastIndexOf(58);
        if (sepID == -1 || sepID == sepTS | sepID - sepTS < 2) {
            throw new InvalidCSNException();
        }
        try {
            this.timestamp = Long.parseLong(value.substring(0, sepTS), 16);
        }
        catch (NumberFormatException ife) {
            throw new InvalidCSNException();
        }
        try {
            this.replicaId = value.substring(sepTS + 1, sepID);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidCSNException();
        }
        try {
            this.operationSequence = Integer.parseInt(value.substring(sepID + 1), 16);
        }
        catch (NumberFormatException ife) {
            throw new InvalidCSNException();
        }
    }

    public DefaultCSN(byte[] value) {
        this.timestamp = (long)(value[0] & 0xFF) << 56 | (long)(value[1] & 0xFF) << 48 | (long)(value[2] & 0xFF) << 40 | (long)(value[3] & 0xFF) << 32 | (long)(value[4] << 24) & 0xFF000000L | (long)(value[5] << 16) & 0xFF0000L | (long)(value[6] << 8) & 0xFF00L | (long)value[7] & 0xFFL;
        this.operationSequence = ((value[8] & 0xFF) << 24) + ((value[9] & 0xFF) << 16) + ((value[10] & 0xFF) << 8) + (value[11] & 0xFF);
        char[] chars = new char[value.length - 12];
        for (int i = 12; i < value.length; ++i) {
            chars[i - 12] = (char)(value[i] & 0xFF);
        }
        this.replicaId = new String(chars);
        this.bytes = value;
    }

    @Override
    public String toOctetString() {
        if (this.csnStr == null) {
            StringBuilder buf = new StringBuilder(40);
            buf.append(this.timestamp);
            buf.append(':');
            buf.append(this.replicaId);
            buf.append(':');
            buf.append(this.operationSequence);
            this.csnStr = buf.toString();
        }
        return this.csnStr;
    }

    @Override
    public byte[] toBytes() {
        if (this.bytes == null) {
            String id = this.replicaId;
            byte[] bb = new byte[8 + id.length() + 4];
            bb[0] = (byte)(this.timestamp >> 56);
            bb[1] = (byte)(this.timestamp >> 48);
            bb[2] = (byte)(this.timestamp >> 40);
            bb[3] = (byte)(this.timestamp >> 32);
            bb[4] = (byte)(this.timestamp >> 24);
            bb[5] = (byte)(this.timestamp >> 16);
            bb[6] = (byte)(this.timestamp >> 8);
            bb[7] = (byte)this.timestamp;
            bb[8] = (byte)(this.operationSequence >> 24);
            bb[9] = (byte)(this.operationSequence >> 16);
            bb[10] = (byte)(this.operationSequence >> 8);
            bb[11] = (byte)this.operationSequence;
            for (int i = 0; i < id.length(); ++i) {
                bb[12 + i] = (byte)id.charAt(i);
            }
            this.bytes = bb;
        }
        return this.bytes;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getReplicaId() {
        return this.replicaId;
    }

    @Override
    public int getOperationSequence() {
        return this.operationSequence;
    }

    public String toString() {
        return this.toOctetString();
    }

    public int hashCode() {
        return this.replicaId.hashCode() ^ (int)this.timestamp ^ this.operationSequence;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CSN)) {
            return false;
        }
        CSN that = (CSN)o;
        return this.timestamp == that.getTimestamp() && this.replicaId.equals(that.getReplicaId()) && this.operationSequence == that.getOperationSequence();
    }

    @Override
    public int compareTo(CSN csn) {
        if (csn == null) {
            return 1;
        }
        long thatTimestamp = csn.getTimestamp();
        if (this.timestamp < thatTimestamp) {
            return -1;
        }
        if (this.timestamp > thatTimestamp) {
            return 1;
        }
        int replicaIdCompareResult = this.replicaId.compareTo(csn.getReplicaId());
        if (replicaIdCompareResult != 0) {
            return replicaIdCompareResult;
        }
        int thatSequence = csn.getOperationSequence();
        if (this.operationSequence < thatSequence) {
            return -1;
        }
        if (this.operationSequence > thatSequence) {
            return 1;
        }
        return 0;
    }
}

