/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.directory.server.i18n.I18n;

public class FilterDialog
extends JDialog {
    private static final long serialVersionUID = 3760565295319626294L;
    public static final String RUN_MODE = "Run";
    public static final String LOAD_MODE = "Load";
    public static final String DEBUG_MODE = "Debug";
    public static final String ANNOTATE_MODE = "Annotate";
    public static final String UNLIMITED = "Unlimited";
    public static final String BASE_SCOPE = "Base Object";
    public static final String SINGLE_SCOPE = "Single Level";
    public static final String SUBTREE_SCOPE = "Subtree Level";
    public static final String LOAD_CMD = "Load";
    public static final String SEARCH_CMD = "Search";
    public static final String CANCEL_CMD = "Cancel";
    private JPanel m_northPnl = new JPanel();
    private JPanel m_centerPnl = new JPanel();
    private JTextArea m_filterText = new JTextArea();
    private JLabel m_scopeLbl = new JLabel();
    private JComboBox m_scopeChoice = new JComboBox();
    private JLabel m_limitLbl = new JLabel();
    private JTextField m_limitField = new JTextField();
    private JPanel m_southPnl = new JPanel();
    private JButton m_searchBut = new JButton();
    private JButton m_cancelBut = new JButton();
    private JScrollPane m_scrollPane = new JScrollPane();
    private final String m_mode;
    private JTextField m_baseText = new JTextField();
    private JPanel m_basePnl = new JPanel();
    private JLabel jLabel1 = new JLabel();

    public FilterDialog(String a_mode, JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.m_mode = a_mode;
        this.initGUI();
    }

    public void addActionListener(ActionListener l_listener) {
        this.m_searchBut.addActionListener(l_listener);
        this.m_cancelBut.addActionListener(l_listener);
    }

    private void initGUI() {
        this.m_baseText.setText("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FilterDialog.this.closeDialog(evt);
            }
        });
        this.pack();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.m_northPnl, new GridBagConstraints(0, 0, 1, 1, 0.9, 0.0, 11, 1, new Insets(5, 5, 6, 0), 0, 0));
        this.getContentPane().add((Component)this.m_centerPnl, new GridBagConstraints(0, 1, 1, 1, 0.9, 0.9, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_southPnl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, 2, 0), 0, 0));
        this.m_northPnl.setLayout(new GridBagLayout());
        this.m_northPnl.setBorder(null);
        this.m_northPnl.add((Component)this.m_scopeLbl, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_northPnl.add((Component)this.m_scopeChoice, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(9, 0, 7, 5), 0, 0));
        this.m_northPnl.add((Component)this.m_limitLbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.m_northPnl.add((Component)this.m_limitField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(11, 0, 9, 10), 0, 0));
        this.m_northPnl.add((Component)this.m_basePnl, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.m_filterText.setText("");
        this.m_filterText.setBorder(null);
        this.m_centerPnl.setLayout(new BorderLayout());
        this.m_centerPnl.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Search Filter", 4, 2, new Font("SansSerif", 0, 14), new Color(60, 60, 60)));
        this.m_scrollPane.getViewport().add(this.m_filterText);
        this.m_centerPnl.add((Component)this.m_scrollPane, "Center");
        this.m_scopeLbl.setText("Scope:");
        this.m_scopeLbl.setFont(new Font("Dialog", 0, 14));
        this.m_scopeChoice.setSize(new Dimension(115, 25));
        this.m_scopeChoice.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.m_scopeChoice.setMinimumSize(new Dimension(115, 25));
        this.m_scopeChoice.setPreferredSize(new Dimension(115, 25));
        this.m_scopeChoice.addItem(BASE_SCOPE);
        this.m_scopeChoice.addItem(SINGLE_SCOPE);
        this.m_scopeChoice.addItem(SUBTREE_SCOPE);
        this.m_limitLbl.setText("Limit:");
        this.m_limitField.setText(UNLIMITED);
        this.m_limitField.setHorizontalAlignment(0);
        this.m_southPnl.setLayout(new FlowLayout(1, 15, 5));
        this.m_southPnl.add(this.m_searchBut);
        if (this.m_mode != "Load") {
            this.m_searchBut.setText(SEARCH_CMD);
            this.m_searchBut.setActionCommand(SEARCH_CMD);
            this.m_southPnl.add(this.m_cancelBut);
        } else {
            this.m_searchBut.setText("Load");
            this.m_searchBut.setActionCommand("Load");
        }
        this.m_cancelBut.setText(CANCEL_CMD);
        this.m_cancelBut.setActionCommand(CANCEL_CMD);
        this.setBounds(new Rectangle(0, 0, 595, 331));
        this.m_basePnl.setLayout(new GridBagLayout());
        this.m_basePnl.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_basePnl.add((Component)this.m_baseText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.jLabel1.setText("Search Base:");
        this.jLabel1.setFont(new Font("SansSerif", 0, 14));
        if (this.m_mode == RUN_MODE) {
            this.setTitle("Search Filter Dialog: Execute mode");
        } else if (this.m_mode == "Load") {
            this.setTitle("Search Filter Dialog: Load mode");
        } else if (this.m_mode == DEBUG_MODE) {
            this.setTitle("Search Filter Dialog: Debug mode");
        } else if (this.m_mode == ANNOTATE_MODE) {
            this.setTitle("Search Filter Dialog: Annotate mode");
            this.m_scopeChoice.setEnabled(false);
            this.m_limitField.setEnabled(false);
            this.m_baseText.setEnabled(false);
        } else {
            throw new RuntimeException(I18n.err((I18n)I18n.ERR_730, (Object[])new Object[0]));
        }
    }

    public void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public String getScope() {
        int l_selected = this.m_scopeChoice.getSelectedIndex();
        return (String)this.m_scopeChoice.getItemAt(l_selected);
    }

    public String getLimit() {
        return this.m_limitField.getText();
    }

    public String getFilter() {
        return this.m_filterText.getText();
    }

    public void setBase(String a_base) {
        this.m_baseText.setText(a_base);
    }

    public void setScope(String a_scope) {
        this.m_scopeChoice.setSelectedItem(a_scope);
    }

    public String getBase() {
        return this.m_baseText.getText();
    }
}

