/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import org.apache.commons.collections.ArrayStack;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescendantCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_719, (Object[])new Object[0]);
    private final Store db;
    private IndexEntry prefetched;
    private Cursor<IndexEntry<ParentIdAndRdn, String>> currentCursor;
    private String currentParentId;
    private ArrayStack cursorStack;
    private ArrayStack parentIdStack;
    private String baseId;
    private boolean topLevel;
    protected static final boolean TOP_LEVEL = true;
    protected static final boolean INNER = false;

    public DescendantCursor(Store db, String baseId, String parentId, Cursor<IndexEntry<ParentIdAndRdn, String>> cursor) throws Exception {
        this(db, baseId, parentId, cursor, true);
    }

    public DescendantCursor(Store db, String baseId, String parentId, Cursor<IndexEntry<ParentIdAndRdn, String>> cursor, boolean topLevel) throws Exception {
        this.db = db;
        this.currentParentId = parentId;
        this.currentCursor = cursor;
        this.cursorStack = new ArrayStack();
        this.parentIdStack = new ArrayStack();
        this.baseId = baseId;
        this.topLevel = topLevel;
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating ChildrenCursor {}", (Object)this);
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    public boolean previous() throws Exception {
        IndexEntry entry;
        this.checkNotClosed("next()");
        boolean hasPrevious = this.currentCursor.previous();
        if (hasPrevious && ((ParentIdAndRdn)(entry = (IndexEntry)this.currentCursor.get()).getTuple().getKey()).getParentId().equals(this.currentParentId)) {
            this.prefetched = entry;
            return true;
        }
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        boolean finished = false;
        while (!finished) {
            boolean hasNext = this.currentCursor.next();
            if (hasNext) {
                IndexEntry cursorEntry = (IndexEntry)this.currentCursor.get();
                ParentIdAndRdn parentIdAndRdn = (ParentIdAndRdn)cursorEntry.getKey();
                if (!parentIdAndRdn.getParentId().equals(this.currentParentId)) {
                    finished = this.cursorStack.size() == 0;
                    if (finished) continue;
                    this.currentCursor.close();
                    this.currentCursor = (Cursor)this.cursorStack.pop();
                    this.currentParentId = (String)this.parentIdStack.pop();
                    continue;
                }
                if (this.topLevel) {
                    this.prefetched = new IndexEntry();
                    this.prefetched.setId(cursorEntry.getId());
                    this.prefetched.setKey(this.baseId);
                } else {
                    this.prefetched = cursorEntry;
                }
                if (parentIdAndRdn.getNbDescendants() > 0) {
                    String newParentId = (String)cursorEntry.getId();
                    Cursor<IndexEntry<ParentIdAndRdn, String>> cursor = this.db.getRdnIndex().forwardCursor();
                    IndexEntry startingPos = new IndexEntry();
                    startingPos.setKey(new ParentIdAndRdn(newParentId, (Rdn[])null));
                    cursor.before(startingPos);
                    this.cursorStack.push(this.currentCursor);
                    this.parentIdStack.push((Object)this.currentParentId);
                    this.currentCursor = cursor;
                    this.currentParentId = newParentId;
                }
                return true;
            }
            finished = this.cursorStack.size() == 0;
            if (finished) continue;
            this.currentCursor.close();
            this.currentCursor = (Cursor)this.cursorStack.pop();
            this.currentParentId = (String)this.parentIdStack.pop();
        }
        return false;
    }

    public IndexEntry<String, String> get() throws Exception {
        this.checkNotClosed("get()");
        return this.prefetched;
    }

    public void close() throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        for (Object cursor : this.cursorStack) {
            ((Cursor)cursor).close();
        }
        this.currentCursor.close();
        super.close();
    }

    public void close(Exception cause) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        for (Object cursor : this.cursorStack) {
            ((Cursor)cursor).close(cause);
        }
        this.currentCursor.close(cause);
        super.close(cause);
    }

    private String dumpCursors(String tabs) {
        StringBuilder sb = new StringBuilder();
        for (Object cursor : this.cursorStack) {
            sb.append(((Cursor)cursor).toString(tabs + "  "));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("DescendantCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#baseId<").append(this.baseId);
        sb.append(", ").append(this.db).append("> :\n");
        sb.append(this.dumpCursors(tabs + "  "));
        if (this.currentCursor != null) {
            sb.append(tabs + "  <current>\n");
            sb.append(this.currentCursor.toString(tabs + "    "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

