/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.SubstringEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstringCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<String, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_725, (Object[])new Object[0]);
    private final boolean hasIndex;
    private final IndexCursor<String, Entry, ID> wrapped;
    private final SubstringEvaluator<ID> evaluator;
    private final ForwardIndexEntry<String, ID> indexEntry = new ForwardIndexEntry();

    public SubstringCursor(Store<Entry, ID> store, SubstringEvaluator<ID> substringEvaluator) throws Exception {
        LOG_CURSOR.debug("Creating SubstringCursor {}", (Object)this);
        this.evaluator = substringEvaluator;
        this.hasIndex = store.hasIndexOn(this.evaluator.getExpression().getAttributeType());
        this.wrapped = this.hasIndex ? store.getIndex(this.evaluator.getExpression().getAttributeType()).forwardCursor() : store.getEntryUuidIndex().forwardCursor();
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.evaluator.getExpression().getInitial() != null && this.hasIndex) {
            ForwardIndexEntry indexEntry = new ForwardIndexEntry();
            indexEntry.setKey(this.evaluator.getExpression().getInitial());
            this.wrapped.before(indexEntry);
        } else {
            this.wrapped.beforeFirst();
        }
        this.clear();
    }

    private void clear() {
        this.setAvailable(false);
        this.indexEntry.setEntry(null);
        this.indexEntry.setId(null);
        this.indexEntry.setKey(null);
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clear();
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    private boolean evaluateCandidate(IndexEntry<String, ID> indexEntry) throws Exception {
        if (this.hasIndex) {
            return this.evaluator.getPattern().matcher(indexEntry.getKey()).matches();
        }
        return this.evaluator.evaluate(indexEntry);
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.setAvailable(true);
            this.indexEntry.setId(entry.getId());
            this.indexEntry.setKey((String)entry.getKey());
            this.indexEntry.setEntry(entry.getEntry());
            return true;
        }
        this.clear();
        return false;
    }

    public boolean next() throws Exception {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.setAvailable(true);
            this.indexEntry.setId(entry.getId());
            this.indexEntry.setKey((String)entry.getKey());
            this.indexEntry.setEntry(entry.getEntry());
            return true;
        }
        this.clear();
        return false;
    }

    public IndexEntry<String, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available()) {
            return this.indexEntry;
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing SubstringCursor {}", (Object)this);
        super.close();
        this.wrapped.close();
        this.clear();
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing SubstringCursor {}", (Object)this);
        super.close(cause);
        this.wrapped.close(cause);
        this.clear();
    }
}

