/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.ChildrenCursor;
import org.apache.directory.server.xdbm.search.impl.OneLevelScopeEvaluator;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneLevelScopeCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<ID, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_719, (Object[])new Object[0]);
    private final Store<Entry, ID> db;
    private final OneLevelScopeEvaluator evaluator;
    private final IndexCursor scopeCursor;
    private final Cursor<IndexEntry<ID, ID>> dereferencedCursor;
    private Cursor<IndexEntry<ID, ID>> cursor;

    public OneLevelScopeCursor(Store<Entry, ID> db, OneLevelScopeEvaluator<Entry, ID> evaluator) throws Exception {
        LOG_CURSOR.debug("Creating OneLevelScopeCursor {}", (Object)this);
        this.db = db;
        this.evaluator = evaluator;
        IndexCursor<ParentIdAndRdn<ID>, Entry, ID> cursor = db.getRdnIndex().forwardCursor();
        ForwardIndexEntry startingPos = new ForwardIndexEntry();
        startingPos.setKey(new ParentIdAndRdn<ID>(evaluator.getBaseId(), (Rdn[])null));
        cursor.before(startingPos);
        this.scopeCursor = new ChildrenCursor<ID>(db, evaluator.getBaseId(), cursor);
        this.dereferencedCursor = evaluator.isDereferencing() ? db.getOneAliasIndex().forwardCursor(evaluator.getBaseId()) : null;
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.cursor = this.scopeCursor;
        this.cursor.beforeFirst();
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.cursor = this.evaluator.isDereferencing() ? this.dereferencedCursor : this.scopeCursor;
        this.cursor.afterLast();
        this.setAvailable(false);
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.cursor == null) {
            this.afterLast();
        }
        if (this.cursor == this.scopeCursor) {
            if (this.evaluator.isDereferencing()) {
                do {
                    this.checkNotClosed("previous()");
                    this.setAvailable(this.cursor.previous());
                } while ((!this.available() || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available());
            } else {
                this.setAvailable(this.cursor.previous());
            }
            return this.available();
        }
        this.setAvailable(this.cursor.previous());
        if (!this.available()) {
            this.cursor = this.scopeCursor;
            this.cursor.afterLast();
            do {
                this.checkNotClosed("previous()");
                this.setAvailable(this.cursor.previous());
            } while ((!this.available() || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available());
            return this.available();
        }
        return true;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.cursor == null) {
            this.beforeFirst();
        }
        if (this.evaluator.isDereferencing()) {
            do {
                this.checkNotClosed("next()");
                this.setAvailable(this.cursor.next());
            } while ((!this.available() || this.db.getAliasIndex().reverseLookup(((IndexEntry)this.cursor.get()).getId()) != null) && this.available());
        } else {
            this.setAvailable(this.cursor.next());
        }
        if (this.cursor == this.dereferencedCursor) {
            return this.available();
        }
        if (!this.available()) {
            if (this.dereferencedCursor != null) {
                this.cursor = this.dereferencedCursor;
                this.cursor.beforeFirst();
                return this.setAvailable(this.cursor.next());
            }
            return false;
        }
        return true;
    }

    public IndexEntry<ID, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available()) {
            return (IndexEntry)this.cursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing OneLevelScopeCursor {}", (Object)this);
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.scopeCursor.close();
        if (this.dereferencedCursor != null) {
            this.dereferencedCursor.close();
        }
        super.close();
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing OneLevelScopeCursor {}", (Object)this);
        if (this.cursor != null) {
            this.cursor.close(cause);
        }
        this.scopeCursor.close(cause);
        if (this.dereferencedCursor != null) {
            this.dereferencedCursor.close(cause);
        }
        super.close(cause);
    }
}

