/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_718, (Object[])new Object[0]);
    private final IndexCursor<V, Entry, ID> uuidCursor;
    private final Evaluator<? extends ExprNode, Entry, ID> childEvaluator;

    public NotCursor(Store<Entry, ID> store, Evaluator<? extends ExprNode, Entry, ID> childEvaluator) throws Exception {
        LOG_CURSOR.debug("Creating NotCursor {}", (Object)this);
        this.childEvaluator = childEvaluator;
        this.uuidCursor = store.getEntryUuidIndex().forwardCursor();
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.uuidCursor.beforeFirst();
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.uuidCursor.afterLast();
        this.setAvailable(false);
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        while (this.uuidCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (this.childEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public boolean next() throws Exception {
        while (this.uuidCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidCursor.get();
            if (this.childEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available()) {
            return (IndexEntry)this.uuidCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing NotCursor {}", (Object)this);
        super.close();
        this.uuidCursor.close();
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing NotCursor {}", (Object)this);
        super.close(cause);
        this.uuidCursor.close(cause);
    }
}

