/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.LessEqEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessEqCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_716, (Object[])new Object[0]);
    private final LessEqEvaluator<V, ID> lessEqEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<V, Entry, ID> uuidIdxCursor;
    private IndexEntry<V, ID> uuidCandidate;

    public LessEqCursor(Store<Entry, ID> db, LessEqEvaluator<V, ID> lessEqEvaluator) throws Exception {
        LOG_CURSOR.debug("Creating LessEqCursor {}", (Object)this);
        this.lessEqEvaluator = lessEqEvaluator;
        AttributeType attributeType = lessEqEvaluator.getExpression().getAttributeType();
        if (db.hasIndexOn(attributeType)) {
            this.userIdxCursor = db.getIndex(attributeType).forwardCursor();
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = db.getEntryUuidIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor != null) {
            int compareValue = this.lessEqEvaluator.getComparator().compare(value, this.lessEqEvaluator.getExpression().getValue().getValue());
            if (compareValue > 0) {
                this.afterLast();
                return;
            }
            if (compareValue == 0) {
                this.last();
                this.previous();
                this.setAvailable(false);
                return;
            }
            this.userIdxCursor.beforeValue(id, value);
            this.setAvailable(false);
        } else {
            super.beforeValue(id, value);
        }
    }

    @Override
    public void before(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            int compareValue = this.lessEqEvaluator.getComparator().compare(element.getKey(), this.lessEqEvaluator.getExpression().getValue().getValue());
            if (compareValue > 0) {
                this.afterLast();
                return;
            }
            if (compareValue == 0) {
                this.last();
                this.previous();
                this.setAvailable(false);
                return;
            }
            this.userIdxCursor.before(element);
            this.setAvailable(false);
        } else {
            super.before(element);
        }
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.lessEqEvaluator.getComparator().compare(value, this.lessEqEvaluator.getExpression().getValue().getValue());
            if (comparedValue >= 0) {
                this.afterLast();
                return;
            }
            this.userIdxCursor.afterValue(id, value);
            this.setAvailable(false);
        } else {
            super.afterValue(id, value);
        }
    }

    @Override
    public void after(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            int comparedValue = this.lessEqEvaluator.getComparator().compare(element.getKey(), this.lessEqEvaluator.getExpression().getValue().getValue());
            if (comparedValue >= 0) {
                this.afterLast();
                return;
            }
            this.userIdxCursor.after(element);
            this.setAvailable(false);
        } else {
            super.after(element);
        }
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.uuidIdxCursor.beforeFirst();
            this.uuidCandidate = null;
        }
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            ForwardIndexEntry advanceTo = new ForwardIndexEntry();
            advanceTo.setKey(this.lessEqEvaluator.getExpression().getValue().getValue());
            this.userIdxCursor.after(advanceTo);
        } else {
            this.uuidIdxCursor.afterLast();
            this.uuidCandidate = null;
        }
        this.setAvailable(false);
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.userIdxCursor != null) {
            return this.setAvailable(this.userIdxCursor.previous());
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            this.uuidCandidate = (IndexEntry)this.uuidIdxCursor.get();
            if (this.lessEqEvaluator.evaluate(this.uuidCandidate)) {
                return this.setAvailable(true);
            }
            this.uuidCandidate = null;
        }
        return this.setAvailable(false);
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.userIdxCursor != null) {
            while (this.userIdxCursor.next()) {
                this.checkNotClosed("next()");
                IndexEntry candidate = (IndexEntry)this.userIdxCursor.get();
                if (this.lessEqEvaluator.getComparator().compare(candidate.getKey(), this.lessEqEvaluator.getExpression().getValue().getValue()) > 0) continue;
                return this.setAvailable(true);
            }
            return this.setAvailable(false);
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            this.uuidCandidate = (IndexEntry)this.uuidIdxCursor.get();
            if (this.lessEqEvaluator.evaluate(this.uuidCandidate)) {
                return this.setAvailable(true);
            }
            this.uuidCandidate = null;
        }
        return this.setAvailable(false);
    }

    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            if (this.available()) {
                return (IndexEntry)this.userIdxCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
        }
        if (this.available()) {
            return this.uuidCandidate;
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing LessEqCursor {}", (Object)this);
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
            this.uuidCandidate = null;
        }
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing LessEqCursor {}", (Object)this);
        super.close(cause);
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close(cause);
        } else {
            this.uuidIdxCursor.close(cause);
            this.uuidCandidate = null;
        }
    }
}

