/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyIndexCursor<K, E, ID>
extends AbstractIndexCursor<K, E, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");

    public EmptyIndexCursor() {
        LOG_CURSOR.debug("Creating EmptyIndexCursor {}", (Object)this);
    }

    @Override
    public void before(IndexEntry<K, ID> element) throws Exception {
        this.checkNotClosed("before()");
    }

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    @Override
    public void after(IndexEntry<K, ID> element) throws Exception {
        this.checkNotClosed("after()");
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
    }

    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        return false;
    }

    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        return false;
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        return false;
    }

    public IndexEntry<K, ID> get() throws Exception {
        this.checkNotClosed("get()");
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_703, (Object[])new Object[0]));
    }

    @Override
    public void afterValue(ID id, K indexValue) throws Exception {
        this.checkNotClosed("after()");
    }

    @Override
    public void beforeValue(ID id, K indexValue) throws Exception {
        this.checkNotClosed("after()");
    }

    public void close() throws Exception {
        LOG_CURSOR.debug("Closing EmptyIndexCursor {}", (Object)this);
        super.close();
    }

    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing EmptyIndexCursor {}", (Object)this);
        super.close(cause);
    }
}

