/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.avl;

import java.net.URI;
import java.util.Comparator;
import org.apache.directory.server.core.partition.impl.btree.AbstractBTreePartition;
import org.apache.directory.server.core.partition.impl.btree.LongComparator;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;
import org.apache.directory.server.xdbm.impl.avl.AvlMasterTable;
import org.apache.directory.server.xdbm.impl.avl.AvlRdnIndex;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.DefaultOptimizer;
import org.apache.directory.server.xdbm.search.impl.DefaultSearchEngine;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.NoOpOptimizer;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvlPartition
extends AbstractBTreePartition<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(AvlPartition.class);

    public AvlPartition(SchemaManager schemaManager) {
        super(schemaManager);
    }

    @Override
    protected void doInit() throws Exception {
        if (!this.initialized) {
            EvaluatorBuilder<Long> evaluatorBuilder = new EvaluatorBuilder<Long>(this, this.schemaManager);
            CursorBuilder<Long> cursorBuilder = new CursorBuilder<Long>(this, evaluatorBuilder);
            this.optimizer = !this.optimizerEnabled ? new NoOpOptimizer() : new DefaultOptimizer<Entry, Long>(this);
            this.searchEngine = new DefaultSearchEngine<Long>(this, cursorBuilder, evaluatorBuilder, this.optimizer);
            if (this.isInitialized()) {
                return;
            }
            this.master = new AvlMasterTable(this.id, (Comparator<Long>)((Object)new LongComparator()), null, false);
            super.doInit();
        }
    }

    @Override
    public Long getDefaultId() {
        return 1L;
    }

    @Override
    public Long getRootId() {
        return 0L;
    }

    public void sync() throws Exception {
    }

    @Override
    public boolean isSyncOnWrite() {
        return false;
    }

    @Override
    public int getCacheSize() {
        return 0;
    }

    @Override
    protected Index<?, Entry, Long> convertAndInit(Index<?, Entry, Long> index) throws Exception {
        AvlRdnIndex<Entry> avlIndex;
        if (index.getAttributeId().equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
            avlIndex = new AvlRdnIndex(index.getAttributeId());
        } else if (index instanceof AvlIndex) {
            avlIndex = (AvlIndex)index;
        } else {
            LOG.debug("Supplied index {} is not a AvlIndex. Will create new AvlIndex using copied configuration parameters.", index);
            avlIndex = new AvlIndex(index.getAttributeId());
        }
        ((AvlIndex)avlIndex).init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId()));
        return avlIndex;
    }

    @Override
    public URI getPartitionPath() {
        return null;
    }
}

