/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.IOException;
import java.util.Comparator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Table;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

public abstract class AbstractTable<K, V>
implements Table<K, V> {
    protected final String name;
    protected SchemaManager schemaManager;
    protected final Comparator<K> keyComparator;
    protected final Comparator<V> valueComparator;
    protected int count;

    protected AbstractTable(SchemaManager schemaManager, String name, Comparator<K> keyComparator, Comparator<V> valueComparator) {
        this.schemaManager = schemaManager;
        this.name = name;
        if (keyComparator == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_591, (Object[])new Object[0]));
        }
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
    }

    @Override
    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    @Override
    public Comparator<V> getValueComparator() {
        return this.valueComparator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int count() throws IOException {
        return this.count;
    }
}

