/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.ApproximateEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public class ApproximateCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = "ApproximateCursors only support positioning by element when a user index exists on the asserted attribute.";
    private final ApproximateEvaluator<V, ID> approximateEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<String, Entry, ID> uuidIdxCursor;
    private boolean available = false;

    public ApproximateCursor(Store<Entry, ID> db, ApproximateEvaluator<V, ID> approximateEvaluator) throws Exception {
        this.approximateEvaluator = approximateEvaluator;
        AttributeType attributeType = approximateEvaluator.getExpression().getAttributeType();
        Value value = approximateEvaluator.getExpression().getValue();
        if (db.hasIndexOn(attributeType)) {
            Index<?, Entry, ID> index = db.getIndex(attributeType);
            this.userIdxCursor = index.forwardCursor(value.getValue());
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = db.getEntryUuidIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    public boolean available() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.available();
        }
        return this.available;
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.beforeValue(id, value);
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.afterValue(id, value);
    }

    public void before(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.before(element);
    }

    public void after(IndexEntry<V, Entry, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }
        this.userIdxCursor.after(element);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.uuidIdxCursor.beforeFirst();
            this.available = false;
        }
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.uuidIdxCursor.afterLast();
            this.available = false;
        }
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.previous();
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.approximateEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public boolean next() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.next();
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.approximateEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public IndexEntry<V, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            return (IndexEntry)this.userIdxCursor.get();
        }
        if (this.available) {
            return (IndexEntry)this.uuidIdxCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
        }
    }
}

