/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAliasDereferencingException;
import org.apache.directory.api.ldap.model.exception.LdapAliasException;
import org.apache.directory.api.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.MultiException;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.AbstractPartition;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.EntryCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.MasterTable;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBTreePartition
extends AbstractPartition
implements Store {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBTreePartition.class);
    private SearchEngine searchEngine;
    private Optimizer optimizer;
    protected boolean optimizerEnabled = true;
    public static final int DEFAULT_CACHE_SIZE = 10000;
    protected int cacheSize = -1;
    protected AtomicBoolean isSyncOnWrite = new AtomicBoolean(true);
    private volatile String suffixId;
    protected URI partitionPath;
    private Set<Index<?, ?, String>> indexedAttributes;
    protected MasterTable master;
    protected Map<String, Index<?, Entry, String>> userIndices = new HashMap();
    protected Map<String, Index<?, Entry, String>> systemIndices = new HashMap();
    protected Index<ParentIdAndRdn, Entry, String> rdnIdx;
    protected Index<String, Entry, String> objectClassIdx;
    protected Index<String, Entry, String> presenceIdx;
    protected Index<String, Entry, String> entryCsnIdx;
    protected Index<Dn, Entry, String> aliasIdx;
    protected Index<String, Entry, String> subAliasIdx;
    protected Index<String, Entry, String> oneAliasIdx;
    protected Index<String, Entry, String> adminRoleIdx;
    protected AttributeType OBJECT_CLASS_AT;
    protected AttributeType ENTRY_CSN_AT;
    protected AttributeType ENTRY_DN_AT;
    protected AttributeType ENTRY_UUID_AT;
    protected AttributeType ALIASED_OBJECT_NAME_AT;
    protected AttributeType ADMINISTRATIVE_ROLE_AT;
    private static final boolean NO_REVERSE = Boolean.FALSE;
    private static final boolean WITH_REVERSE = Boolean.TRUE;
    protected static final boolean ADD_CHILD = true;
    protected static final boolean REMOVE_CHILD = false;
    private ReadWriteLock rwLock;

    protected AbstractBTreePartition(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.indexedAttributes = new HashSet();
        this.OBJECT_CLASS_AT = schemaManager.getAttributeType("objectClass");
        this.ALIASED_OBJECT_NAME_AT = schemaManager.getAttributeType("aliasedObjectName");
        this.ENTRY_CSN_AT = schemaManager.getAttributeType("entryCSN");
        this.ENTRY_DN_AT = schemaManager.getAttributeType("entryDN");
        this.ENTRY_UUID_AT = schemaManager.getAttributeType("entryUUID");
        this.ADMINISTRATIVE_ROLE_AT = schemaManager.getAttributeType("administrativeRole");
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isOptimizerEnabled() {
        return this.optimizerEnabled;
    }

    public void setOptimizerEnabled(boolean optimizerEnabled) {
        this.optimizerEnabled = optimizerEnabled;
    }

    @Override
    public void setPartitionPath(URI partitionPath) {
        this.checkInitialized("partitionPath");
        this.partitionPath = partitionPath;
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite.get();
    }

    @Override
    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.checkInitialized("syncOnWrite");
        this.isSyncOnWrite.set(isSyncOnWrite);
    }

    protected void setupSystemIndices() throws Exception {
        Index index;
        if (this.getPresenceIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.3", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getRdnIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.50", this.partitionPath, WITH_REVERSE);
            this.addIndex(index);
        }
        if (this.getAliasIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.7", this.partitionPath, WITH_REVERSE);
            this.addIndex(index);
        }
        if (this.getOneAliasIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.5", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getSubAliasIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.18060.0.4.1.2.6", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getObjectClassIndex() == null) {
            index = this.createSystemIndex("2.5.4.0", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getEntryCsnIndex() == null) {
            index = this.createSystemIndex("1.3.6.1.4.1.4203.666.1.7", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        if (this.getAdministrativeRoleIndex() == null) {
            index = this.createSystemIndex("2.5.18.5", this.partitionPath, NO_REVERSE);
            this.addIndex(index);
        }
        for (String oid : this.systemIndices.keySet()) {
            Index<?, Entry, String> index2 = this.systemIndices.get(oid);
            index2 = this.convertAndInit(index2);
            this.systemIndices.put(oid, index2);
        }
        this.rdnIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
        this.presenceIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
        this.aliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
        this.oneAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
        this.subAliasIdx = this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
        this.objectClassIdx = this.systemIndices.get("2.5.4.0");
        this.entryCsnIdx = this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
        this.adminRoleIdx = this.systemIndices.get("2.5.18.5");
    }

    protected void setupUserIndices() throws Exception {
        HashMap tmp = new HashMap();
        for (String oid : this.userIndices.keySet()) {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
            MatchingRule mr = attributeType.getEquality();
            if (mr != null) {
                Index<?, Entry, String> index = this.userIndices.get(oid);
                index = this.convertAndInit(index);
                tmp.put(oid, index);
                continue;
            }
            LOG.error(I18n.err((I18n)I18n.ERR_4, (Object[])new Object[]{attributeType.getName()}));
        }
        this.userIndices = tmp;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    protected abstract Index<?, Entry, String> convertAndInit(Index<?, Entry, String> var1) throws Exception;

    @Override
    public URI getPartitionPath() {
        return this.partitionPath;
    }

    protected void doDestroy() throws LdapException, Exception {
        LOG.debug("destroy() called on store for {}", (Object)this.suffixDn);
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        MultiException errors = new MultiException(I18n.err((I18n)I18n.ERR_577, (Object[])new Object[0]));
        for (Index<?, Entry, String> index : this.userIndices.values()) {
            try {
                index.close();
                LOG.debug("Closed {} user index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err((I18n)I18n.ERR_124, (Object[])new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        for (Index<?, Entry, String> index : this.systemIndices.values()) {
            try {
                index.close();
                LOG.debug("Closed {} system index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err((I18n)I18n.ERR_124, (Object[])new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        try {
            this.master.close();
            LOG.debug(I18n.err((I18n)I18n.ERR_125, (Object[])new Object[]{this.suffixDn}));
        }
        catch (Throwable t) {
            LOG.error(I18n.err((I18n)I18n.ERR_126, (Object[])new Object[0]), t);
            errors.addThrowable(t);
        }
        if (errors.size() > 0) {
            throw errors;
        }
    }

    protected void doInit() throws Exception {
        if (this.indexedAttributes != null && this.indexedAttributes.size() > 0) {
            for (Index<?, ?, String> index : this.indexedAttributes) {
                this.addIndex(index);
            }
        }
        this.setupSystemIndices();
        this.setupUserIndices();
    }

    private void dumpAllRdnIdx() throws Exception {
        if (LOG.isDebugEnabled()) {
            this.dumpRdnIdx(Partition.ROOT_ID, "");
            System.out.println("-----------------------------");
        }
    }

    private void dumpRdnIdx() throws Exception {
        if (LOG.isDebugEnabled()) {
            this.dumpRdnIdx(Partition.ROOT_ID, 1, "");
            System.out.println("-----------------------------");
        }
    }

    public void dumpRdnIdx(String id, String tabs) throws Exception {
        Cursor<IndexEntry<ParentIdAndRdn, String>> cursor = this.rdnIdx.forwardCursor();
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey(new ParentIdAndRdn(id, (Rdn[])null));
        cursor.before(startingPos);
        while (cursor.next()) {
            IndexEntry entry = (IndexEntry)cursor.get();
            System.out.println(tabs + entry);
        }
        cursor.close();
    }

    private void dumpRdnIdx(String id, int nbSibbling, String tabs) throws Exception {
        Cursor<IndexEntry<ParentIdAndRdn, String>> cursor = this.rdnIdx.forwardCursor();
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey(new ParentIdAndRdn(id, (Rdn[])null));
        cursor.before(startingPos);
        for (int countChildren = 0; cursor.next() && countChildren < nbSibbling; ++countChildren) {
            IndexEntry entry = (IndexEntry)cursor.get();
            System.out.println(tabs + entry);
            int nbChildren = ((ParentIdAndRdn)entry.getKey()).getNbChildren();
            if (nbChildren <= 0) continue;
            this.dumpRdnIdx((String)entry.getId(), nbChildren, tabs + "  ");
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddOperationContext addContext) throws LdapException {
        try {
            Attribute entryCsn;
            this.setRWLock((OperationContext)addContext);
            Entry entry = ((ClonedServerEntry)addContext.getEntry()).getClonedEntry();
            Dn entryDn = entry.getDn();
            this.lockRead();
            try {
                if (this.getEntryId(entryDn) != null) {
                    LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{entryDn.getName()}));
                    throw ne;
                }
            }
            finally {
                this.unlockRead();
            }
            String parentId = null;
            Dn parentDn = null;
            ParentIdAndRdn key = null;
            if (entryDn.equals((Object)this.suffixDn)) {
                parentId = Partition.ROOT_ID;
                key = new ParentIdAndRdn(parentId, this.suffixDn.getRdns());
            } else {
                parentDn = entryDn.getParent();
                this.lockRead();
                try {
                    parentId = this.getEntryId(parentDn);
                }
                finally {
                    this.unlockRead();
                }
                key = new ParentIdAndRdn(parentId, entryDn.getRdn());
            }
            if (parentId == null) {
                throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_216_ID_FOR_PARENT_NOT_FOUND, (Object[])new Object[]{parentDn}));
            }
            Attribute entryUUID = entry.get(this.ENTRY_UUID_AT);
            String id = null;
            id = entryUUID == null ? this.master.getNextId(entry) : entryUUID.getString();
            Attribute objectClass = entry.get(this.OBJECT_CLASS_AT);
            if (objectClass == null) {
                String msg = I18n.err((I18n)I18n.ERR_217, (Object[])new Object[]{entryDn.getName(), entry});
                ResultCodeEnum rc = ResultCodeEnum.OBJECT_CLASS_VIOLATION;
                LdapSchemaViolationException e = new LdapSchemaViolationException(rc, msg);
                throw e;
            }
            for (Value value : objectClass) {
                if (value.equals("top")) continue;
                this.objectClassIdx.add((String)value.getNormValue(), id);
            }
            if (objectClass.contains(new String[]{"alias"})) {
                Attribute aliasAttr = entry.get(this.ALIASED_OBJECT_NAME_AT);
                this.addAliasIndices(id, entryDn, new Dn(this.schemaManager, new String[]{aliasAttr.getString()}));
            }
            if ((entryCsn = entry.get(this.ENTRY_CSN_AT)) == null) {
                String msg = I18n.err((I18n)I18n.ERR_219, (Object[])new Object[]{entryDn.getName(), entry});
                throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, msg);
            }
            this.entryCsnIdx.add(entryCsn.getString(), id);
            if (entry.containsAttribute(this.ADMINISTRATIVE_ROLE_AT)) {
                Attribute adminRoles = entry.get(this.ADMINISTRATIVE_ROLE_AT);
                for (Value value : adminRoles) {
                    this.adminRoleIdx.add((String)value.getNormValue(), id);
                }
                this.presenceIdx.add(this.ADMINISTRATIVE_ROLE_AT.getOid(), id);
            }
            for (Attribute attribute : entry) {
                AttributeType attributeType = attribute.getAttributeType();
                String attributeOid = attributeType.getOid();
                if (!this.hasUserIndexOn(attributeType)) continue;
                Index<?, Entry, String> idx = this.getUserIndex(attributeType);
                for (Value value : attribute) {
                    idx.add(value.getNormValue(), id);
                }
                this.presenceIdx.add(attributeOid, id);
            }
            entry.put("entryParentId", new String[]{parentId});
            this.lockWrite();
            try {
                this.rdnIdx.add(key, id);
                if (parentId != Partition.ROOT_ID) {
                    this.updateRdnIdx(parentId, true, 0);
                }
                entry.removeAttributes(new AttributeType[]{this.ENTRY_DN_AT});
                this.master.put(id, entry);
            }
            finally {
                this.unlockWrite();
            }
            if (this.isSyncOnWrite.get()) {
                this.sync();
            }
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry delete(DeleteOperationContext deleteContext) throws LdapException {
        try {
            this.setRWLock((OperationContext)deleteContext);
            Dn dn = deleteContext.getDn();
            String id = null;
            this.lockRead();
            try {
                id = this.getEntryId(dn);
            }
            finally {
                this.unlockRead();
            }
            if (id == null) {
                throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_699, (Object[])new Object[]{dn}));
            }
            int childCount = this.getChildCount(id);
            if (childCount > 0) {
                LdapContextNotEmptyException cnee = new LdapContextNotEmptyException(I18n.err((I18n)I18n.ERR_700, (Object[])new Object[]{dn}));
                throw cnee;
            }
            Entry deletedEntry = this.delete(id);
            this.updateCache((OperationContext)deleteContext);
            return deletedEntry;
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage());
        }
    }

    protected void updateRdnIdx(String parentId, boolean addRemove, int nbDescendant) throws Exception {
        boolean isFirst = true;
        if (parentId.equals(Partition.ROOT_ID)) {
            return;
        }
        ParentIdAndRdn parent = this.rdnIdx.reverseLookup(parentId);
        while (parent != null) {
            if (isFirst) {
                if (addRemove) {
                    parent.setNbChildren(parent.getNbChildren() + 1);
                } else {
                    parent.setNbChildren(parent.getNbChildren() - 1);
                }
                isFirst = false;
            }
            if (addRemove) {
                parent.setNbDescendants(parent.getNbDescendants() + (nbDescendant + 1));
            } else {
                parent.setNbDescendants(parent.getNbDescendants() - (nbDescendant + 1));
            }
            this.rdnIdx.drop(parentId);
            this.rdnIdx.add(parent, parentId);
            parentId = parent.getParentId();
            parent = this.rdnIdx.reverseLookup(parentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry delete(String id) throws LdapException {
        try {
            Entry entry = null;
            this.lockRead();
            try {
                entry = (Entry)this.master.get(id);
            }
            finally {
                this.unlockRead();
            }
            if (entry == null) {
                throw new LdapNoSuchObjectException("Cannot find an entry for UUID " + id);
            }
            Attribute objectClass = entry.get(this.OBJECT_CLASS_AT);
            if (objectClass.contains(new String[]{"alias"})) {
                this.dropAliasIndices(id);
            }
            for (Value value : objectClass) {
                this.objectClassIdx.drop(value.getString(), id);
            }
            ParentIdAndRdn parent = this.rdnIdx.reverseLookup(id);
            this.updateRdnIdx(parent.getParentId(), false, 0);
            this.entryCsnIdx.drop(entry.get(this.ENTRY_CSN_AT).getString(), id);
            if (entry.containsAttribute(this.ADMINISTRATIVE_ROLE_AT)) {
                Attribute adminRoles = entry.get(this.ADMINISTRATIVE_ROLE_AT);
                for (Value value : adminRoles) {
                    this.adminRoleIdx.drop((String)value.getNormValue(), id);
                }
                this.presenceIdx.drop(this.ADMINISTRATIVE_ROLE_AT.getOid(), id);
            }
            for (Attribute attribute : entry) {
                AttributeType attributeType = attribute.getAttributeType();
                String attributeOid = attributeType.getOid();
                if (!this.hasUserIndexOn(attributeType)) continue;
                Index<?, Entry, String> index = this.getUserIndex(attributeType);
                for (Value value : attribute) {
                    index.drop(value.getValue(), id);
                }
                this.presenceIdx.drop(attributeOid, id);
            }
            this.lockWrite();
            try {
                this.rdnIdx.drop(id);
                this.dumpRdnIdx();
                this.master.remove(id);
            }
            finally {
                this.unlockWrite();
            }
            if (this.isSyncOnWrite.get()) {
                this.sync();
            }
            return entry;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        try {
            this.setRWLock((OperationContext)searchContext);
            PartitionSearchResult searchResult = this.searchEngine.computeResult(this.schemaManager, searchContext);
            EntryCursorAdaptor result = new EntryCursorAdaptor(this, searchResult);
            return new BaseEntryFilteringCursor((Cursor)result, searchContext, this.schemaManager);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        this.setRWLock((OperationContext)lookupContext);
        String id = this.getEntryId(lookupContext.getDn());
        if (id == null) {
            return null;
        }
        Entry entry = this.fetch(id, lookupContext.getDn());
        return entry;
    }

    @Override
    public Entry fetch(String id) throws LdapException {
        try {
            this.rwLock.readLock().lock();
            Dn dn = this.buildEntryDn(id);
            Entry entry = this.fetch(id, dn);
            return entry;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry fetch(String id, Dn dn) throws LdapException {
        try {
            Entry entry = this.lookupCache(id);
            if (entry != null) {
                if (!entry.containsAttribute(this.ENTRY_DN_AT)) {
                    entry.add(this.ENTRY_DN_AT, new String[]{dn.getName()});
                }
                return new ClonedServerEntry(entry);
            }
            try {
                this.rwLock.readLock().lock();
                entry = (Entry)this.master.get(id);
            }
            finally {
                this.rwLock.readLock().unlock();
            }
            if (entry != null) {
                entry.setDn(dn);
                if (!entry.containsAttribute(this.ENTRY_DN_AT)) {
                    entry.add(this.ENTRY_DN_AT, new String[]{dn.getName()});
                }
                this.addToCache(id, entry);
                return new ClonedServerEntry(entry);
            }
            return null;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        try {
            this.setRWLock((OperationContext)modifyContext);
            Entry modifiedEntry = this.modify(modifyContext.getDn(), modifyContext.getModItems().toArray(new Modification[0]));
            modifyContext.setAlteredEntry(modifiedEntry);
            this.updateCache((OperationContext)modifyContext);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final synchronized Entry modify(Dn dn, Modification ... mods) throws Exception {
        String id = this.getEntryId(dn);
        Entry entry = (Entry)this.master.get(id);
        block5: for (Modification mod : mods) {
            Attribute attrMods = mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.modifyAdd(id, entry, attrMods);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.modifyRemove(id, entry, attrMods);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.modifyReplace(id, entry, attrMods);
                    continue block5;
                }
                default: {
                    throw new LdapException(I18n.err((I18n)I18n.ERR_221, (Object[])new Object[0]));
                }
            }
        }
        this.updateCsnIndex(entry, id);
        entry.removeAttributes(new AttributeType[]{this.ENTRY_DN_AT});
        this.master.put(id, entry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
        return entry;
    }

    private void modifyAdd(String id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.add((String)value.getNormValue(), id);
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Index<?, Entry, String> index = this.getUserIndex(attributeType);
            for (Value value : mods) {
                index.add(value.getNormValue(), id);
            }
            if (!this.presenceIdx.forward(modsOid, id)) {
                this.presenceIdx.add(modsOid, id);
            }
        } else if (modsOid.equals("2.5.18.5")) {
            for (Value value : mods) {
                this.adminRoleIdx.add((String)value.getNormValue(), id);
            }
            if (!this.presenceIdx.forward(modsOid, id)) {
                this.presenceIdx.add(modsOid, id);
            }
        }
        for (Value value : mods) {
            entry.add(mods.getAttributeType(), new Value[]{value});
        }
        if (modsOid.equals("2.5.4.1")) {
            Dn ndn = this.getEntryDn(id);
            this.addAliasIndices(id, ndn, new Dn(this.schemaManager, new String[]{mods.getString()}));
        }
    }

    private void modifyReplace(String id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (attributeType.equals((Object)this.OBJECT_CLASS_AT)) {
            for (Value value : entry.get(this.OBJECT_CLASS_AT)) {
                this.objectClassIdx.drop((String)value.getNormValue(), id);
            }
            for (Value value : mods) {
                if (value.equals("top")) continue;
                this.objectClassIdx.add((String)value.getNormValue(), id);
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Index<?, Entry, String> index = this.getUserIndex(attributeType);
            Attribute oldAttribute = entry.get(mods.getAttributeType());
            if (oldAttribute != null) {
                for (Value value : oldAttribute) {
                    index.drop(value.getNormValue(), id);
                }
            }
            for (Value value : mods) {
                index.add(value.getNormValue(), id);
            }
            if (mods.size() == 0) {
                this.presenceIdx.drop(modsOid, id);
            }
        } else if (attributeType.equals((Object)this.ADMINISTRATIVE_ROLE_AT)) {
            for (Value value : entry.get(this.ADMINISTRATIVE_ROLE_AT)) {
                this.objectClassIdx.drop((String)value.getNormValue(), id);
            }
            for (Value value : mods) {
                this.adminRoleIdx.add((String)value.getNormValue(), id);
            }
        }
        String aliasAttributeOid = this.schemaManager.getAttributeTypeRegistry().getOidByName("aliasedObjectName");
        if (mods.getAttributeType().equals((Object)this.ALIASED_OBJECT_NAME_AT)) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(new Attribute[]{mods});
        } else {
            entry.remove(new Attribute[]{mods});
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            Dn entryDn = this.getEntryDn(id);
            this.addAliasIndices(id, entryDn, new Dn(this.schemaManager, new String[]{mods.getString()}));
        }
    }

    private void modifyRemove(String id, Entry entry, Attribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err((I18n)I18n.ERR_215, (Object[])new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        AttributeType attributeType = mods.getAttributeType();
        if (attributeType.equals((Object)this.OBJECT_CLASS_AT)) {
            if (mods.size() == 0) {
                for (Value objectClass : entry.get(this.OBJECT_CLASS_AT)) {
                    this.objectClassIdx.drop((String)objectClass.getNormValue(), id);
                }
            } else {
                for (Value value : mods) {
                    this.objectClassIdx.drop((String)value.getNormValue(), id);
                }
            }
        } else if (this.hasUserIndexOn(attributeType)) {
            Index<?, Entry, String> index = this.getUserIndex(attributeType);
            Attribute attribute = entry.get(attributeType).clone();
            int nbValues = 0;
            if (attribute != null) {
                nbValues = attribute.size();
            }
            if (mods.size() == 0) {
                index.drop(id);
                nbValues = 0;
            } else {
                for (Value value : mods) {
                    if (attribute.contains(new Value[]{value})) {
                        --nbValues;
                        attribute.remove(new Value[]{value});
                    }
                    index.drop(value.getNormValue(), id);
                }
            }
            if (nbValues == 0) {
                this.presenceIdx.drop(modsOid, id);
            }
        } else if (modsOid.equals("2.5.18.5")) {
            for (Value value : mods) {
                this.adminRoleIdx.drop((String)value.getNormValue(), id);
            }
            if (null == this.adminRoleIdx.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        if (mods.size() == 0) {
            entry.removeAttributes(new AttributeType[]{mods.getAttributeType()});
        } else {
            Attribute entryAttr = entry.get(mods.getAttributeType());
            for (Value value : mods) {
                entryAttr.remove(new Value[]{value});
            }
            if (entryAttr.size() == 0) {
                entry.removeAttributes(new String[]{entryAttr.getId()});
            }
        }
        if (mods.getAttributeType().equals((Object)this.ALIASED_OBJECT_NAME_AT)) {
            this.dropAliasIndices(id);
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        if (moveContext.getNewSuperior().isDescendantOf(moveContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        try {
            this.setRWLock((OperationContext)moveContext);
            Dn oldDn = moveContext.getDn();
            Dn newSuperior = moveContext.getNewSuperior();
            Dn newDn = moveContext.getNewDn();
            Entry modifiedEntry = moveContext.getModifiedEntry();
            this.move(oldDn, newSuperior, newDn, modifiedEntry);
            this.updateCache((OperationContext)moveContext);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final synchronized void move(Dn oldDn, Dn newSuperiorDn, Dn newDn, Entry modifiedEntry) throws Exception {
        String newParentId = this.getEntryId(newSuperiorDn);
        if (newParentId == null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        String newId = this.getEntryId(newDn);
        if (newId != null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        String entryId = this.getEntryId(oldDn);
        String oldParentId = this.getParentId(entryId);
        this.dropMovedAliasIndices(oldDn);
        ParentIdAndRdn movedEntry = this.rdnIdx.reverseLookup(entryId);
        this.updateRdnIdx(oldParentId, false, movedEntry.getNbDescendants());
        this.rdnIdx.drop(entryId);
        movedEntry.setParentId(newParentId);
        this.rdnIdx.add(movedEntry, entryId);
        this.updateRdnIdx(newParentId, true, movedEntry.getNbDescendants());
        Dn aliasTarget = this.aliasIdx.reverseLookup(entryId);
        if (null != aliasTarget) {
            aliasTarget.apply(this.schemaManager);
            this.addAliasIndices(entryId, this.buildEntryDn(entryId), aliasTarget);
        }
        if (modifiedEntry == null) {
            modifiedEntry = this.fetch(entryId);
        }
        modifiedEntry.put("entryParentId", new String[]{newParentId});
        modifiedEntry.removeAttributes(new AttributeType[]{this.ENTRY_DN_AT});
        this.master.put(entryId, modifiedEntry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (moveAndRenameContext.getNewSuperiorDn().isDescendantOf(moveAndRenameContext.getDn())) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, "cannot place an entry below itself");
        }
        try {
            this.setRWLock((OperationContext)moveAndRenameContext);
            Dn oldDn = moveAndRenameContext.getDn();
            Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
            Rdn newRdn = moveAndRenameContext.getNewRdn();
            boolean deleteOldRdn = moveAndRenameContext.getDeleteOldRdn();
            Entry modifiedEntry = moveAndRenameContext.getModifiedEntry();
            this.moveAndRename(oldDn, newSuperiorDn, newRdn, modifiedEntry, deleteOldRdn);
            this.updateCache((OperationContext)moveAndRenameContext);
        }
        catch (LdapException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final synchronized void moveAndRename(Dn oldDn, Dn newSuperiorDn, Rdn newRdn, Entry modifiedEntry, boolean deleteOldRdn) throws Exception {
        String oldId = this.getEntryId(oldDn);
        if (oldId == null) {
            LdapNoSuchObjectException nse = new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{oldDn}));
            throw nse;
        }
        String newSuperiorId = this.getEntryId(newSuperiorDn);
        if (newSuperiorId == null) {
            LdapNoSuchObjectException nse = new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{newSuperiorDn}));
            throw nse;
        }
        Dn newDn = newSuperiorDn.add(newRdn);
        String newId = this.getEntryId(newDn);
        if (newId != null) {
            LdapEntryAlreadyExistsException ne = new LdapEntryAlreadyExistsException(I18n.err((I18n)I18n.ERR_250_ENTRY_ALREADY_EXISTS, (Object[])new Object[]{newSuperiorDn.getName()}));
            throw ne;
        }
        if (modifiedEntry == null) {
            modifiedEntry = (Entry)this.master.get(oldId);
        }
        this.rename(oldId, newRdn, deleteOldRdn, modifiedEntry);
        this.moveAndRename(oldDn, oldId, newSuperiorDn, newRdn, modifiedEntry);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    private void moveAndRename(Dn oldDn, String entryId, Dn newSuperior, Rdn newRdn, Entry modifiedEntry) throws Exception {
        String newParentId = this.getEntryId(newSuperior);
        String oldParentId = this.getParentId(entryId);
        this.dropMovedAliasIndices(oldDn);
        ParentIdAndRdn movedEntry = this.rdnIdx.reverseLookup(entryId);
        this.updateRdnIdx(oldParentId, false, movedEntry.getNbDescendants());
        this.rdnIdx.drop(entryId);
        movedEntry.setParentId(newParentId);
        movedEntry.setRdns(newRdn);
        this.rdnIdx.add(movedEntry, entryId);
        this.updateRdnIdx(newParentId, true, movedEntry.getNbDescendants());
        this.dumpRdnIdx();
        Dn aliasTarget = this.aliasIdx.reverseLookup(entryId);
        if (null != aliasTarget) {
            aliasTarget.apply(this.schemaManager);
            this.addAliasIndices(entryId, this.buildEntryDn(entryId), aliasTarget);
        }
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        try {
            this.setRWLock((OperationContext)renameContext);
            Dn oldDn = renameContext.getDn();
            Rdn newRdn = renameContext.getNewRdn();
            boolean deleteOldRdn = renameContext.getDeleteOldRdn();
            if (renameContext.getEntry() != null) {
                Entry modifiedEntry = renameContext.getModifiedEntry();
                this.rename(oldDn, newRdn, deleteOldRdn, modifiedEntry);
            } else {
                this.rename(oldDn, newRdn, deleteOldRdn, null);
            }
            this.updateCache((OperationContext)renameContext);
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    private void rename(String oldId, Rdn newRdn, boolean deleteOldRdn, Entry entry) throws Exception {
        if (entry == null) {
            entry = (Entry)this.master.get(oldId);
        }
        Dn updn = entry.getDn();
        newRdn.apply(this.schemaManager);
        for (Ava newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            Object newNormValue = newAtav.getNormValue().getValue();
            AttributeType newRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(newNormType);
            entry.add(newRdnAttrType, new Value[]{newAtav.getValue()});
            if (!this.hasUserIndexOn(newRdnAttrType)) continue;
            Index<?, Entry, String> index = this.getUserIndex(newRdnAttrType);
            index.add(newNormValue, oldId);
            if (this.presenceIdx.forward(newNormType, oldId)) continue;
            this.presenceIdx.add(newNormType, oldId);
        }
        if (deleteOldRdn) {
            Rdn oldRdn = updn.getRdn();
            for (Ava oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (Ava newAtav : newRdn) {
                    if (!oldAtav.equals((Object)newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = oldAtav.getNormValue().getString();
                AttributeType oldRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(oldNormType);
                entry.remove(oldRdnAttrType, new String[]{oldNormValue});
                if (!this.hasUserIndexOn(oldRdnAttrType)) continue;
                Index<?, Entry, String> index = this.getUserIndex(oldRdnAttrType);
                index.drop(oldNormValue, this.id);
                if (null != index.reverseLookup(oldId)) continue;
                this.presenceIdx.drop(oldNormType, oldId);
            }
        }
        entry.removeAttributes(new AttributeType[]{this.ENTRY_DN_AT});
        this.master.put(oldId, entry);
    }

    @Override
    public final synchronized void rename(Dn dn, Rdn newRdn, boolean deleteOldRdn, Entry entry) throws Exception {
        String oldId = this.getEntryId(dn);
        this.rename(oldId, newRdn, deleteOldRdn, entry);
        String parentId = this.getParentId(oldId);
        ParentIdAndRdn parentIdAndRdn = this.rdnIdx.reverseLookup(oldId);
        this.rdnIdx.drop(oldId);
        parentIdAndRdn.setParentId(parentId);
        parentIdAndRdn.setRdns(newRdn);
        this.rdnIdx.add(parentIdAndRdn, oldId);
        if (this.isSyncOnWrite.get()) {
            this.sync();
        }
    }

    public final void unbind(UnbindOperationContext unbindContext) throws LdapException {
    }

    public boolean hasEntry(HasEntryOperationContext entryContext) throws LdapException {
        try {
            this.setRWLock((OperationContext)entryContext);
            String id = this.getEntryId(entryContext.getDn());
            Entry entry = this.fetch(id, entryContext.getDn());
            return entry != null;
        }
        catch (LdapException e) {
            return false;
        }
    }

    private void updateCsnIndex(Entry entry, String id) throws Exception {
        String entryCsn = entry.get("entryCSN").getString();
        this.entryCsnIdx.drop(id);
        this.entryCsnIdx.add(entryCsn, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dn buildEntryDn(String id) throws Exception {
        String parentId = id;
        String rootId = Partition.ROOT_ID;
        Rdn[] rdnArray = new Rdn[10];
        int pos = 0;
        try {
            ParentIdAndRdn cur;
            this.rwLock.readLock().lock();
            do {
                Rdn[] rdns;
                if ((cur = this.rdnIdx.reverseLookup(parentId)) == null) {
                    Dn dn = null;
                    return dn;
                }
                for (Rdn rdn : rdns = cur.getRdns()) {
                    if (pos > 0 && pos % 10 == 0) {
                        Rdn[] newRdnArray = new Rdn[pos + 10];
                        System.arraycopy(rdnArray, 0, newRdnArray, 0, pos);
                        rdnArray = newRdnArray;
                    }
                    rdnArray[pos++] = rdn;
                }
            } while (!(parentId = cur.getParentId()).equals(rootId));
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        Dn dn = new Dn(this.schemaManager, Arrays.copyOf(rdnArray, pos));
        return dn;
    }

    @Override
    public int count() throws Exception {
        return this.master.count();
    }

    @Override
    public final int getChildCount(String id) throws LdapException {
        try {
            ParentIdAndRdn parentIdAndRdn = this.rdnIdx.reverseLookup(id);
            return parentIdAndRdn.getNbChildren();
        }
        catch (Exception e) {
            throw new LdapOperationErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public final Dn getEntryDn(String id) throws Exception {
        return this.buildEntryDn(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getEntryId(Dn dn) throws LdapException {
        if (Dn.isNullOrEmpty((Dn)dn)) {
            return Partition.ROOT_ID;
        }
        ParentIdAndRdn suffixKey = new ParentIdAndRdn(Partition.ROOT_ID, this.suffixDn.getRdns());
        try {
            this.rwLock.readLock().lock();
            String currentId = this.rdnIdx.forwardLookup(suffixKey);
            for (int i = dn.size() - this.suffixDn.size(); i > 0; --i) {
                Rdn rdn = dn.getRdn(i - 1);
                ParentIdAndRdn currentRdn = new ParentIdAndRdn(currentId, rdn);
                if ((currentId = this.rdnIdx.forwardLookup(currentRdn)) == null) break;
            }
            String string = currentId;
            this.rwLock.readLock().unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.rwLock.readLock().unlock();
                throw throwable;
            }
            catch (Exception e) {
                throw new LdapException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParentId(String childId) throws Exception {
        try {
            this.rwLock.readLock().lock();
            ParentIdAndRdn key = this.rdnIdx.reverseLookup(childId);
            if (key == null) {
                String string = null;
                return string;
            }
            String string = key.getParentId();
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSuffixId() throws Exception {
        if (this.suffixId == null) {
            ParentIdAndRdn key = new ParentIdAndRdn(Partition.ROOT_ID, this.suffixDn.getRdns());
            try {
                this.rwLock.readLock().lock();
                this.suffixId = this.rdnIdx.forwardLookup(key);
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }
        return this.suffixId;
    }

    @Override
    public void addIndex(Index<?, Entry, String> index) throws Exception {
        this.checkInitialized("addIndex");
        AttributeType attributeType = null;
        try {
            attributeType = this.schemaManager.lookupAttributeTypeRegistry(index.getAttributeId());
        }
        catch (LdapNoSuchAttributeException lnsae) {
            LOG.error("Cannot initialize the index for AttributeType {}, this value does not exist", (Object)index.getAttributeId());
            return;
        }
        String oid = attributeType.getOid();
        if (SYS_INDEX_OIDS.contains(oid)) {
            if (!this.systemIndices.containsKey(oid)) {
                this.systemIndices.put(oid, index);
            }
        } else if (!this.userIndices.containsKey(oid)) {
            this.userIndices.put(oid, index);
        }
    }

    public void addIndexedAttributes(Index<?, Entry, String> ... indexes) {
        for (Index<?, Entry, String> index : indexes) {
            this.indexedAttributes.add(index);
        }
    }

    public void setIndexedAttributes(Set<Index<?, ?, String>> indexedAttributes) {
        this.indexedAttributes = indexedAttributes;
    }

    public Set<Index<?, ?, String>> getIndexedAttributes() {
        return this.indexedAttributes;
    }

    @Override
    public Iterator<String> getUserIndices() {
        return this.userIndices.keySet().iterator();
    }

    @Override
    public Iterator<String> getSystemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    @Override
    public Index<?, Entry, String> getIndex(AttributeType attributeType) throws IndexNotFoundException {
        String id = attributeType.getOid();
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{id, id}));
    }

    @Override
    public Index<?, Entry, String> getUserIndex(AttributeType attributeType) throws IndexNotFoundException {
        if (attributeType == null) {
            throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{attributeType, attributeType}));
        }
        String oid = attributeType.getOid();
        if (this.userIndices.containsKey(oid)) {
            return this.userIndices.get(oid);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_3, (Object[])new Object[]{attributeType, attributeType}));
    }

    @Override
    public Index<?, Entry, String> getSystemIndex(AttributeType attributeType) throws IndexNotFoundException {
        if (attributeType == null) {
            throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_2, (Object[])new Object[]{attributeType, attributeType}));
        }
        String oid = attributeType.getOid();
        if (this.systemIndices.containsKey(oid)) {
            return this.systemIndices.get(oid);
        }
        throw new IndexNotFoundException(I18n.err((I18n)I18n.ERR_2, (Object[])new Object[]{attributeType, attributeType}));
    }

    @Override
    public Index<Dn, Entry, String> getAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.7");
    }

    @Override
    public Index<String, Entry, String> getOneAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.5");
    }

    @Override
    public Index<String, Entry, String> getSubAliasIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.6");
    }

    @Override
    public Index<String, Entry, String> getObjectClassIndex() {
        return this.systemIndices.get("2.5.4.0");
    }

    @Override
    public Index<String, Entry, String> getEntryCsnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.4203.666.1.7");
    }

    public Index<String, Entry, String> getAdministrativeRoleIndex() {
        return this.systemIndices.get("2.5.18.5");
    }

    @Override
    public Index<String, Entry, String> getPresenceIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.3");
    }

    @Override
    public Index<ParentIdAndRdn, Entry, String> getRdnIndex() {
        return this.systemIndices.get("1.3.6.1.4.1.18060.0.4.1.2.50");
    }

    @Override
    public boolean hasUserIndexOn(AttributeType attributeType) throws LdapException {
        return this.userIndices.containsKey(attributeType.getOid());
    }

    @Override
    public boolean hasSystemIndexOn(AttributeType attributeType) throws LdapException {
        return this.systemIndices.containsKey(attributeType.getOid());
    }

    @Override
    public boolean hasIndexOn(AttributeType attributeType) throws LdapException {
        return this.hasUserIndexOn(attributeType) || this.hasSystemIndexOn(attributeType);
    }

    protected void addAliasIndices(String aliasId, Dn aliasDn, Dn aliasTarget) throws Exception {
        if (!aliasTarget.isDescendantOf(this.suffixDn)) {
            String msg = I18n.err((I18n)I18n.ERR_225, (Object[])new Object[]{this.suffixDn.getName()});
            LdapAliasDereferencingException e = new LdapAliasDereferencingException(msg);
            throw e;
        }
        String targetId = this.getEntryId(aliasTarget);
        if (null == targetId) {
            String msg = I18n.err((I18n)I18n.ERR_581, (Object[])new Object[]{aliasDn.getName(), aliasTarget});
            LdapAliasException e = new LdapAliasException(msg);
            throw e;
        }
        if (null != this.aliasIdx.reverseLookup(targetId)) {
            String msg = I18n.err((I18n)I18n.ERR_227, (Object[])new Object[0]);
            LdapAliasDereferencingException e = new LdapAliasDereferencingException(msg);
            throw e;
        }
        this.aliasIdx.add(aliasTarget, aliasId);
        Dn ancestorDn = aliasDn.getParent();
        String ancestorId = this.getEntryId(ancestorDn);
        Dn normalizedAliasTargetParentDn = aliasTarget.getParent();
        if (!aliasDn.isDescendantOf(normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(ancestorId, targetId);
        }
        while (!ancestorDn.equals((Object)this.suffixDn) && null != ancestorId) {
            if (!aliasTarget.isDescendantOf(ancestorDn)) {
                this.subAliasIdx.add(ancestorId, targetId);
            }
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(ancestorDn);
        }
    }

    protected void dropAliasIndices(String aliasId) throws Exception {
        Dn targetDn = this.aliasIdx.reverseLookup(aliasId);
        targetDn.apply(this.schemaManager);
        String targetId = this.getEntryId(targetDn);
        if (targetId == null) {
            return;
        }
        Dn aliasDn = this.getEntryDn(aliasId);
        Dn ancestorDn = aliasDn.getParent();
        String ancestorId = this.getEntryId(ancestorDn);
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.suffixDn) && ancestorDn.size() > this.suffixDn.size()) {
            ancestorDn = ancestorDn.getParent();
            ancestorId = this.getEntryId(ancestorDn);
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    protected void dropMovedAliasIndices(Dn movedBase) throws Exception {
        String movedBaseId = this.getEntryId(movedBase);
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
    }

    protected void dropAliasIndices(String aliasId, Dn movedBase) throws Exception {
        Dn targetDn = this.aliasIdx.reverseLookup(aliasId);
        targetDn.apply(this.schemaManager);
        String targetId = this.getEntryId(targetDn);
        Dn aliasDn = this.getEntryDn(aliasId);
        Dn ancestorDn = new Dn(this.schemaManager, new Rdn[]{movedBase.getRdn(movedBase.size() - 1)});
        String ancestorId = this.getEntryId(ancestorDn);
        if (aliasDn.equals((Object)movedBase)) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.suffixDn)) {
            ancestorDn = new Dn(this.schemaManager, new Rdn[]{ancestorDn.getRdn(ancestorDn.size() - 1)});
            ancestorId = this.getEntryId(ancestorDn);
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    private void dumpIndex(OutputStream stream, Index<?, Entry, String> index) {
        try {
            Cursor<IndexEntry<?, String>> cursor = index.forwardCursor();
            while (cursor.next()) {
                IndexEntry entry = (IndexEntry)cursor.get();
                System.out.println(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dumpIndex(OutputStream stream, String name) throws IOException {
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(name);
            if (attributeType == null) {
                stream.write(Strings.getBytesUtf8((String)("Cannot find an index for AttributeType names " + name)));
                return;
            }
            if (attributeType.getOid().equals("1.3.6.1.4.1.18060.0.4.1.2.50")) {
                this.dumpIndex(stream, this.rdnIdx);
            }
        }
        catch (LdapException le) {
            stream.write(Strings.getBytesUtf8((String)("Cannot find an index for AttributeType names " + name)));
        }
    }

    public String toString() {
        return "Partition<" + this.id + ">";
    }

    protected abstract Index createSystemIndex(String var1, URI var2, boolean var3) throws Exception;

    @Override
    public MasterTable getMasterTable() {
        return this.master;
    }

    private void lockRead() {
        this.rwLock.readLock().lock();
    }

    private void unlockRead() {
        this.rwLock.readLock().unlock();
    }

    private void lockWrite() {
        this.rwLock.writeLock().lock();
    }

    private void unlockWrite() {
        this.rwLock.writeLock().unlock();
    }

    public void updateCache(OperationContext opCtx) {
    }

    public Entry lookupCache(String id) {
        return null;
    }

    public void addToCache(String id, Entry entry) {
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    private void setRWLock(OperationContext operationContext) {
        if (operationContext.getSession() != null) {
            this.rwLock = operationContext.getSession().getDirectoryService().getOperationManager().getRWLock();
        } else if (this.rwLock == null) {
            this.rwLock = new ReentrantReadWriteLock();
        }
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.rwLock;
    }
}

