/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.PresenceEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<String, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_724, (Object[])new Object[0]);
    private final IndexCursor<String, Entry, ID> ndnCursor;
    private final IndexCursor<String, Entry, ID> presenceCursor;
    private final PresenceEvaluator<ID> presenceEvaluator;
    private boolean available = false;

    public PresenceCursor(Store<Entry, ID> db, PresenceEvaluator<ID> presenceEvaluator) throws Exception {
        this.presenceEvaluator = presenceEvaluator;
        AttributeType type = presenceEvaluator.getAttributeType();
        if (db.hasUserIndexOn(type)) {
            this.presenceCursor = db.getPresenceIndex().forwardCursor(type.getOid());
            this.ndnCursor = null;
        } else {
            this.presenceCursor = null;
            this.ndnCursor = db.getNdnIndex().forwardCursor();
        }
    }

    public boolean available() {
        if (this.presenceCursor != null) {
            return this.presenceCursor.available();
        }
        return this.available;
    }

    @Override
    public void beforeValue(ID id, String value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.presenceCursor != null) {
            this.presenceCursor.beforeValue(id, value);
            return;
        }
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void before(IndexEntry<String, Entry, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.presenceCursor != null) {
            this.presenceCursor.before(element);
            return;
        }
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void afterValue(ID id, String value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.presenceCursor != null) {
            this.presenceCursor.afterValue(id, value);
            return;
        }
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void after(IndexEntry<String, Entry, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.presenceCursor != null) {
            this.presenceCursor.after(element);
            return;
        }
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.presenceCursor != null) {
            this.presenceCursor.beforeFirst();
            return;
        }
        this.ndnCursor.beforeFirst();
        this.available = false;
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.presenceCursor != null) {
            this.presenceCursor.afterLast();
            return;
        }
        this.ndnCursor.afterLast();
        this.available = false;
    }

    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.first();
        }
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.last();
        }
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.previous();
        }
        while (this.ndnCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.ndnCursor.get();
            if (!this.presenceEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.presenceCursor != null) {
            return this.presenceCursor.next();
        }
        while (this.ndnCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.ndnCursor.get();
            if (!this.presenceEvaluator.evaluate(candidate)) continue;
            this.available = true;
            return true;
        }
        this.available = false;
        return false;
    }

    public IndexEntry<String, Entry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.presenceCursor != null) {
            if (this.presenceCursor.available()) {
                return (IndexEntry)this.presenceCursor.get();
            }
            throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
        }
        if (this.available) {
            IndexEntry indexEntry = (IndexEntry)this.ndnCursor.get();
            indexEntry.setValue(this.presenceEvaluator.getAttributeType().getOid());
            return indexEntry;
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.presenceCursor != null) {
            this.presenceCursor.close();
        } else {
            this.ndnCursor.close();
        }
    }
}

