/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.LeafEvaluator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.filter.ApproximateNode;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApproximateEvaluator<T, ID extends Comparable<ID>>
extends LeafEvaluator<T, ID> {
    public ApproximateEvaluator(ApproximateNode<T> node, Store<Entry, ID> db, SchemaManager schemaManager) throws Exception {
        super(node, db, schemaManager);
        if (db.hasIndexOn(this.attributeType)) {
            this.idx = db.getIndex(this.attributeType);
            this.normalizer = null;
            this.ldapComparator = null;
        } else {
            this.idx = null;
            MatchingRule mr = this.attributeType.getEquality();
            if (mr == null) {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_709, (Object[])new Object[]{node}));
            }
            this.normalizer = mr.getNormalizer();
            this.ldapComparator = mr.getLdapComparator();
        }
    }

    @Override
    public ApproximateNode<T> getExpression() {
        return (ApproximateNode)this.node;
    }

    @Override
    public boolean evaluateEntry(Entry entry) throws Exception {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = (AttributeType)descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null) {
            return this.idx.reverse(id);
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    @Override
    public boolean evaluate(IndexEntry<?, Entry, ID> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.node.getValue().getValue(), indexEntry.getId());
        }
        Entry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup((Comparable)indexEntry.getId());
            indexEntry.setObject(entry);
        }
        return this.evaluateEntry(entry);
    }

    private boolean evaluate(Attribute attribute) throws Exception {
        for (Value value : attribute) {
            if (this.ldapComparator.compare(value.getNormValue(), this.node.getValue().getNormValue()) != 0) continue;
            return true;
        }
        return false;
    }
}

