/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardIndexEntry<V, O>
implements IndexEntry<V, O> {
    private final Tuple<V, Long> tuple = new Tuple();
    private O obj;

    public void setTuple(Tuple<V, Long> tuple, O entry) {
        this.tuple.setKey(tuple.getKey());
        this.tuple.setValue(tuple.getValue());
        this.obj = entry;
    }

    @Override
    public Long getId() {
        return this.tuple.getValue();
    }

    @Override
    public V getValue() {
        return this.tuple.getKey();
    }

    @Override
    public void setId(Long id) {
        this.tuple.setValue(id);
    }

    @Override
    public void setValue(V value) {
        this.tuple.setKey(value);
    }

    @Override
    public O getObject() {
        if (this.obj == null) {
            return null;
        }
        return this.obj;
    }

    @Override
    public void setObject(O obj) {
        this.obj = obj;
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public void clear() {
        this.obj = null;
        this.tuple.setKey(null);
        this.tuple.setValue(null);
    }

    @Override
    public void copy(IndexEntry<V, O> entry) {
        this.obj = entry.getObject();
        this.tuple.setKey(entry.getValue());
        this.tuple.setValue(entry.getId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ForwardIndexEntry[ ");
        buf.append(this.tuple.getKey());
        buf.append(", ");
        buf.append(this.tuple.getValue());
        buf.append(" ]");
        return buf.toString();
    }
}

